/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.dex;

import com.google.classyshark.silverghost.TokensMapper;
import com.google.classyshark.silverghost.contentreader.dex.DexlibLoader;
import com.google.classyshark.silverghost.translator.Translator;
import com.google.classyshark.silverghost.translator.apk.dashboard.ApkDashboard;
import com.google.classyshark.silverghost.translator.jar.JarInfoTranslator;
import com.google.classyshark.silverghost.translator.java.dex.MultidexReader;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.DexFile;

public class DexInfoTranslator
implements Translator {
    private File apkFile;
    private String dexFileName;
    private int index;
    private List<Translator.ELEMENT> elements = new ArrayList<Translator.ELEMENT>();

    public DexInfoTranslator(String string, File file) {
        this.apkFile = file;
        this.dexFileName = string;
    }

    @Override
    public String getClassName() {
        return this.dexFileName;
    }

    @Override
    public void addMapper(TokensMapper tokensMapper) {
    }

    @Override
    public void apply() {
        try {
            this.elements.clear();
            File file = MultidexReader.extractClassesDex(this.dexFileName, this.apkFile, this);
            DexFile dexFile = DexlibLoader.loadDexFile(file);
            DexBackedDexFile dexBackedDexFile = (DexBackedDexFile)dexFile;
            Translator.ELEMENT eLEMENT = new Translator.ELEMENT("\nclasses: " + dexBackedDexFile.getClassCount(), Translator.TAG.MODIFIER);
            this.elements.add(eLEMENT);
            eLEMENT = new Translator.ELEMENT("\nstrings: " + dexBackedDexFile.getStringCount(), Translator.TAG.DOCUMENT);
            this.elements.add(eLEMENT);
            eLEMENT = new Translator.ELEMENT("\ntypes: " + dexBackedDexFile.getTypeCount(), Translator.TAG.DOCUMENT);
            this.elements.add(eLEMENT);
            eLEMENT = new Translator.ELEMENT("\nprotos: " + dexBackedDexFile.getProtoCount(), Translator.TAG.DOCUMENT);
            this.elements.add(eLEMENT);
            eLEMENT = new Translator.ELEMENT("\nfields: " + dexBackedDexFile.getFieldCount(), Translator.TAG.DOCUMENT);
            this.elements.add(eLEMENT);
            eLEMENT = new Translator.ELEMENT("\nmethods: " + dexBackedDexFile.getMethodCount(), Translator.TAG.IDENTIFIER);
            this.elements.add(eLEMENT);
            eLEMENT = new Translator.ELEMENT("\n\nFile size: " + JarInfoTranslator.readableFileSize(file.length()), Translator.TAG.DOCUMENT);
            this.elements.add(eLEMENT);
            eLEMENT = new Translator.ELEMENT("\n\nClasses with Native Calls\n", Translator.TAG.MODIFIER);
            this.elements.add(eLEMENT);
            Set<String> set = ApkDashboard.getClassesWithNativeMethodsPerDexIndex(this.index, file);
            for (String string : set) {
                eLEMENT = new Translator.ELEMENT(string + "\n", Translator.TAG.DOCUMENT);
                this.elements.add(eLEMENT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public List<Translator.ELEMENT> getElementsList() {
        return this.elements;
    }

    @Override
    public List<String> getDependencies() {
        return new LinkedList<String>();
    }

    public void setIndex(int n) {
        this.index = n;
    }
}

