/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.apk.dashboard;

import com.google.classyshark.silverghost.contentreader.dex.DexlibLoader;
import com.google.classyshark.silverghost.translator.apk.dashboard.ApkNativeMethodsVisitor;
import com.google.classyshark.silverghost.translator.apk.dashboard.ClassesDexDataEntry;
import com.google.classyshark.silverghost.translator.apk.dashboard.PrivateNativeLibsInspector;
import com.google.classyshark.silverghost.translator.apk.dashboard.SyntheticAccessorsInspector;
import com.google.classyshark.silverghost.translator.java.dex.MultidexReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.DexFile;
import org.ow2.asmdex.ApplicationReader;
import org.ow2.asmdex.ApplicationVisitor;

public class ApkDashboard
implements Iterable<ClassesDexDataEntry> {
    public ArrayList<ClassesDexDataEntry> classesDexEntries = new ArrayList();
    public ArrayList<ClassesDexDataEntry> customClassesDexEntries = new ArrayList();
    public List<String> nativeLibs = new ArrayList<String>();
    public ArrayList<String> nativeDependencies = new ArrayList();
    public List<String> nativeErrors = new LinkedList<String>();
    public File apkFile;

    public ApkDashboard(File file) {
        this.apkFile = file;
    }

    public void inspect() {
        MultidexReader.fillApkDashboard(this.apkFile, this);
    }

    @Override
    public Iterator<ClassesDexDataEntry> iterator() {
        return new ClassesDexIterator();
    }

    public List<String> getNativeErrors() {
        return this.nativeErrors;
    }

    public List<String> getFullPathNativeLibNamesSorted() {
        Collections.sort(this.nativeLibs);
        return this.nativeLibs;
    }

    public List<String> getNativeLibNamesSorted() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.nativeDependencies);
        LinkedList<String> linkedList = new LinkedList<String>(linkedHashSet);
        Collections.sort(linkedList);
        List<String> list = ApkDashboard.extractLibNamesFromFullPaths(this.getFullPathNativeLibNamesSorted());
        return list;
    }

    public String getPrivateLibErrorTag(String string) {
        boolean bl = PrivateNativeLibsInspector.isPrivate(string, this.getNativeLibNamesSorted());
        if (bl) {
            return " -- private api!";
        }
        return "";
    }

    public static Set<String> getClassesWithNativeMethodsPerDexIndex(int n, File file) {
        ClassesDexDataEntry classesDexDataEntry = ApkDashboard.fillAnalysisPerClassesDexIndex(n, file);
        return classesDexDataEntry.classesWithNativeMethods;
    }

    public static ClassesDexDataEntry fillAnalysisPerClassesDexIndex(int n, File file) {
        Object object;
        Object object2;
        ClassesDexDataEntry classesDexDataEntry = new ClassesDexDataEntry(n);
        try {
            object2 = new FileInputStream(file);
            object = new ApkNativeMethodsVisitor(classesDexDataEntry);
            ApplicationReader applicationReader = new ApplicationReader(262144, (InputStream)object2);
            applicationReader.accept((ApplicationVisitor)object, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            object2 = DexlibLoader.loadDexFile(file);
            object = (DexBackedDexFile)object2;
            classesDexDataEntry.allMethods = ((DexBackedDexFile)object).getMethodCount();
            classesDexDataEntry.syntheticAccessors = new SyntheticAccessorsInspector((DexFile)object2).getSyntheticAccessors();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return classesDexDataEntry;
    }

    private static List<String> extractLibNamesFromFullPaths(List<String> list) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = iterator.next();
            if (string.contains("/")) {
                string2 = string2.substring(string2.lastIndexOf("/") + 1, string2.length() - 1);
            }
            linkedList.add(string2);
        }
        return linkedList;
    }

    private class ClassesDexIterator
    implements Iterator<ClassesDexDataEntry> {
        private int currentClassesDex = 0;
        private int currentCustomClassesDex = 0;

        @Override
        public boolean hasNext() {
            return this.currentClassesDex < ApkDashboard.this.classesDexEntries.size() || this.currentCustomClassesDex < ApkDashboard.this.customClassesDexEntries.size();
        }

        @Override
        public ClassesDexDataEntry next() {
            ClassesDexDataEntry classesDexDataEntry = new ClassesDexDataEntry(0);
            if (this.currentClassesDex < ApkDashboard.this.classesDexEntries.size()) {
                for (ClassesDexDataEntry classesDexDataEntry2 : ApkDashboard.this.classesDexEntries) {
                    int n = this.currentToDexIndex(this.currentClassesDex);
                    if (n != classesDexDataEntry2.index) continue;
                    classesDexDataEntry = classesDexDataEntry2;
                    ++this.currentClassesDex;
                    break;
                }
            } else {
                ++this.currentCustomClassesDex;
                classesDexDataEntry = ApkDashboard.this.customClassesDexEntries.get(0);
            }
            return classesDexDataEntry;
        }

        @Override
        public void remove() {
        }

        private int currentToDexIndex(int n) {
            if (n == 0) {
                return 0;
            }
            return ++n;
        }
    }
}

