/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.methodscounter;

import com.google.classyshark.silverghost.contentreader.dex.DexlibLoader;
import com.google.classyshark.silverghost.methodscounter.ClassInfo;
import com.google.classyshark.silverghost.methodscounter.ClassNode;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.Method;

public class RootBuilder {
    public ClassNode fillClassesWithMethods(File file) {
        if (file.getName().endsWith("aar")) {
            return this.fillFromAar(file);
        }
        if (file.getName().endsWith("jar")) {
            return this.fillFromJar(file);
        }
        if (file.getName().endsWith("dex")) {
            return this.fillFromDex(file);
        }
        return this.fillFromApk(file);
    }

    public ClassNode fillClassesWithMethods(String string) {
        return this.fillClassesWithMethods(new File(string));
    }

    private ClassNode fillFromAar(File file) {
        try {
            ZipEntry zipEntry;
            File file2 = File.createTempFile("classes", "jar");
            file2.deleteOnExit();
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                if (!zipEntry.getName().endsWith(".jar")) continue;
                byte[] byArray = new byte[8192];
                while ((n = zipInputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)fileOutputStream).close();
                zipInputStream.closeEntry();
                zipInputStream.close();
                return this.fillFromJar(file2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ClassNode("");
    }

    private ClassNode fillFromJar(File file) {
        ClassNode classNode = new ClassNode(file.getName());
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                ClassParser classParser = new ClassParser(jarFile.getInputStream(jarEntry), jarEntry.getName());
                JavaClass javaClass = classParser.parse();
                ClassInfo classInfo = new ClassInfo(javaClass.getClassName(), javaClass.getMethods().length);
                classNode.add(classInfo);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error reading file: " + file + ". " + iOException.getMessage());
            iOException.printStackTrace(System.err);
        }
        return classNode;
    }

    private void fillFromDex(File file, ClassNode classNode) {
        try {
            DexFile dexFile = DexlibLoader.loadDexFile(file);
            Set<? extends ClassDef> set = dexFile.getClasses();
            for (ClassDef classDef : set) {
                int n = 0;
                for (Method method : classDef.getMethods()) {
                    ++n;
                }
                String string = classDef.getType().replaceAll("\\/", "\\.").substring(1, classDef.getType().length() - 1);
                ClassInfo object2 = new ClassInfo(string, n);
                classNode.add(object2);
            }
        }
        catch (Exception exception) {
            System.err.println("Error parsing Dexfile: " + file.getName() + ": " + exception.getMessage());
            exception.printStackTrace(System.err);
        }
    }

    private ClassNode fillFromDex(File file) {
        ClassNode classNode = new ClassNode(file.getName());
        this.fillFromDex(file, classNode);
        return classNode;
    }

    private ClassNode fillFromApk(File file) {
        ClassNode classNode = new ClassNode(file.getName());
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));){
            ZipEntry zipEntry;
            byte[] byArray = new byte[1024];
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().endsWith(".dex")) continue;
                System.out.println("Parsing " + zipEntry.getName());
                File file2 = File.createTempFile("classyshark", "dex");
                file2.deleteOnExit();
                try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                    int n;
                    while ((n = zipInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                this.fillFromDex(file2, classNode);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error reading file: " + file + ". " + iOException.getMessage());
            iOException.printStackTrace(System.err);
        }
        return classNode;
    }
}

