/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost;

import com.google.classyshark.silverghost.contentreader.ContentReader;
import com.google.classyshark.silverghost.exporter.Exporter;
import com.google.classyshark.silverghost.exporter.FlatMethodCountExporter;
import com.google.classyshark.silverghost.exporter.MethodCountExporter;
import com.google.classyshark.silverghost.exporter.TreeMethodCountExporter;
import com.google.classyshark.silverghost.methodscounter.ClassNode;
import com.google.classyshark.silverghost.methodscounter.RootBuilder;
import com.google.classyshark.silverghost.translator.Translator;
import com.google.classyshark.silverghost.translator.TranslatorFactory;
import com.google.classyshark.silverghost.translator.apk.ApkTranslator;
import com.google.classyshark.silverghost.translator.dex.DexMethodsDumper;
import com.google.classyshark.silverghost.translator.dex.DexStringsDumper;
import java.io.File;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

public class SilverGhostFacade {
    private SilverGhostFacade() {
    }

    public static List<String> getAllClassNames(File file) {
        ContentReader contentReader = new ContentReader(file);
        contentReader.load();
        return contentReader.getAllClassNames();
    }

    public static void exportClassFromApk(List<String> list) {
        File file = new File(list.get(1));
        String string = list.get(2);
        Translator translator = TranslatorFactory.createTranslator(string, file, SilverGhostFacade.getAllClassNames(file));
        try {
            translator.apply();
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Class doesn't exist in the writeArchive");
            return;
        }
        try {
            Exporter.writeCurrentClass(translator.getClassName(), translator.toString());
        }
        catch (Exception exception) {
            System.err.println("Internal error - couldn't write file");
        }
    }

    public static String getGeneratedClassString(String string, File file) {
        String string2;
        Translator translator = TranslatorFactory.createTranslator(string, file, SilverGhostFacade.getAllClassNames(file));
        try {
            translator.apply();
            string2 = translator.toString();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Class doesn't exist in the writeArchive");
            return "";
        }
        return string2;
    }

    public static void inspectApk(List<String> list) {
        if (!new File(list.get(1)).getName().endsWith(".apk")) {
            System.err.println("Not an apk file ==> java -jar ClassyShark.jar -inspect APK_FILE");
            return;
        }
        ApkTranslator apkTranslator = new ApkTranslator(new File(list.get(1)));
        apkTranslator.apply();
        System.out.print(apkTranslator);
    }

    public static String getManifest(File file) {
        if (!file.getName().endsWith(".apk")) {
            return "";
        }
        Translator translator = TranslatorFactory.createTranslator("AndroidManifest.xml", file);
        translator.apply();
        return translator.toString();
    }

    public static List<String> getAllMethods(File file) {
        if (!file.getName().endsWith(".apk")) {
            return new LinkedList<String>();
        }
        return DexMethodsDumper.dumpMethods(file);
    }

    public static void inspectPackages(List<String> list) {
        String string = list.get(1);
        File file = new File(string);
        if (!file.exists()) {
            System.err.printf("File '%s' does not exist", string);
            return;
        }
        RootBuilder rootBuilder = new RootBuilder();
        MethodCountExporter methodCountExporter = new TreeMethodCountExporter(new PrintWriter(System.out));
        if (list.size() > 2) {
            for (int i = 2; i < list.size(); ++i) {
                if (!list.get(i).equals("-flat")) continue;
                methodCountExporter = new FlatMethodCountExporter(new PrintWriter(System.out));
            }
        }
        ClassNode classNode = rootBuilder.fillClassesWithMethods(string);
        methodCountExporter.exportMethodCounts(classNode);
    }

    public static List<String> getAllStrings(File file) {
        if (!file.getName().endsWith(".apk")) {
            return new LinkedList<String>();
        }
        return DexStringsDumper.dumpStrings(file);
    }

    public static void exportArchive(List<String> list) {
        File file = new File(list.get(1));
        try {
            Exporter.writeArchive(file, SilverGhostFacade.getAllClassNames(file));
        }
        catch (Exception exception) {
            System.err.println("Internal error - couldn't write file");
        }
    }

    public static boolean isMultiDex(File file) {
        ContentReader contentReader = new ContentReader(file);
        contentReader.load();
        List<String> list = contentReader.getAllClassNames();
        int n = 0;
        for (String string : list) {
            if (!string.endsWith(".dex") || ++n != 2) continue;
            return true;
        }
        return false;
    }

    public static boolean isCustomMultiDex(File file) {
        if (!SilverGhostFacade.isMultiDex(file)) {
            return false;
        }
        ContentReader contentReader = new ContentReader(file);
        contentReader.load();
        List<String> list = contentReader.getAllClassNames();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : list) {
            if (!string.endsWith(".dex")) continue;
            linkedList.add(string);
        }
        if (list.contains("classes1.dex")) {
            return true;
        }
        for (String string : linkedList) {
            if (string.startsWith("classes")) continue;
            return true;
        }
        return false;
    }
}

