/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost;

import com.google.classyshark.gui.panel.reducer.Reducer;
import com.google.classyshark.silverghost.FullArchiveReader;
import com.google.classyshark.silverghost.TokensMapper;
import com.google.classyshark.silverghost.contentreader.ContentReader;
import com.google.classyshark.silverghost.plugins.EmptyFullArchiveReader;
import com.google.classyshark.silverghost.plugins.IdentityMapper;
import com.google.classyshark.silverghost.translator.Translator;
import com.google.classyshark.silverghost.translator.TranslatorFactory;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class SilverGhost {
    private File binaryArchive;
    private Reducer reducer;
    private Translator translator;
    private ContentReader contentReader;
    private String manifestStr = "";
    private static TokensMapper tokensMapper = new IdentityMapper();
    private static FullArchiveReader fullArchiveReader = new EmptyFullArchiveReader();

    public void setBinaryArchive(File file) {
        this.binaryArchive = file;
        tokensMapper = new IdentityMapper();
    }

    public void readContents() {
        this.contentReader = new ContentReader(this.getBinaryArchive());
        long l = System.currentTimeMillis();
        this.contentReader.load();
        this.reducer = new Reducer(this.contentReader.getAllClassNames());
        System.out.println("Archive Reading " + (System.currentTimeMillis() - l) + " ms ");
        if (this.binaryArchive.getName().endsWith(".apk")) {
            Translator translator = TranslatorFactory.createTranslator("AndroidManifest.xml", this.binaryArchive);
            translator.apply();
            this.manifestStr = translator.toString();
        }
        fullArchiveReader.readAsyncArchive(this.binaryArchive);
    }

    public File getBinaryArchive() {
        return this.binaryArchive;
    }

    public List<ContentReader.Component> getComponents() {
        return this.contentReader.getAllComponents();
    }

    public List<String> getAllClassNames() {
        return this.contentReader.getAllClassNames();
    }

    public String getAutoCompleteClassName() {
        return this.reducer.getAutocompleteClassName();
    }

    public void initClassNameFiltering() {
        this.reducer.reduce("");
    }

    public List<String> filter(String string) {
        return this.reducer.reduce(string);
    }

    public boolean isArchiveError() {
        boolean bl = this.contentReader.getAllClassNames().isEmpty();
        boolean bl2 = this.contentReader.getAllClassNames().size() == 1 && this.contentReader.getAllClassNames().contains("AndroidManifest.xml");
        return bl || bl2;
    }

    public TokensMapper readMappingFile(File file) {
        tokensMapper.readMappings(file);
        return tokensMapper;
    }

    public void addMappings(TokensMapper tokensMapper) {
        SilverGhost.tokensMapper = tokensMapper;
    }

    public void translateArchiveElement(String string) {
        this.translator = TranslatorFactory.createTranslator(string, this.getBinaryArchive(), this.reducer.getAllClassNames(), fullArchiveReader);
        this.translator.addMapper(tokensMapper);
        this.translator.apply();
    }

    public List<Translator.ELEMENT> getArchiveElementTokens() {
        return this.translator.getElementsList();
    }

    public List<String> getImportsForCurrentClass() {
        return this.translator.getDependencies();
    }

    public String getCurrentClassName() {
        return this.translator.getClassName();
    }

    public String getCurrentClassContent() {
        return this.translator.toString();
    }

    public List<Translator.ELEMENT> getManifestMatches(String string) {
        LinkedList<Translator.ELEMENT> linkedList = new LinkedList<Translator.ELEMENT>();
        if (this.manifestStr.isEmpty()) {
            return linkedList;
        }
        linkedList.add(new Translator.ELEMENT("AndroidManifest.xml - ", Translator.TAG.IDENTIFIER));
        linkedList.add(new Translator.ELEMENT("\n::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::", Translator.TAG.SELECTION));
        String[] stringArray = this.manifestStr.split("[\\r\\n]+");
        if (string.length() > 2) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                if (!stringArray[i].contains(string) && !stringArray[i].equalsIgnoreCase(string)) continue;
                linkedList.add(new Translator.ELEMENT("\n", Translator.TAG.ANNOTATION));
                if (i > 2) {
                    n = i;
                    linkedList.add(new Translator.ELEMENT(stringArray[n - 1], Translator.TAG.ANNOTATION));
                    linkedList.add(new Translator.ELEMENT(stringArray[n - 2], Translator.TAG.ANNOTATION));
                }
                linkedList.add(new Translator.ELEMENT(stringArray[i], Translator.TAG.IDENTIFIER));
                if (i < stringArray.length - 4) {
                    n = i;
                    linkedList.add(new Translator.ELEMENT(stringArray[n + 1], Translator.TAG.ANNOTATION));
                    linkedList.add(new Translator.ELEMENT(stringArray[n + 2], Translator.TAG.ANNOTATION));
                }
                linkedList.add(new Translator.ELEMENT("", Translator.TAG.ANNOTATION));
                linkedList.add(new Translator.ELEMENT("::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::", Translator.TAG.SELECTION));
            }
            linkedList.add(new Translator.ELEMENT("", Translator.TAG.ANNOTATION));
        }
        return linkedList;
    }
}

