/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.theme;

import com.google.classyshark.gui.theme.Theme;
import com.google.classyshark.gui.theme.dark.DarkTheme;
import com.google.classyshark.gui.theme.light.LightTheme;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class ThemeManager {
    private static final String PROP_FILE = "classyshark_ui.properties";
    private static final String THEME_KEY = "Theme";
    private static final String[] themes = new String[]{"Light", "Dark"};
    private static final int LIGHT = 0;
    private static final int DARK = 1;

    public static void saveCurrentTheme(Theme theme) {
        try {
            Properties properties = new Properties();
            properties.setProperty(THEME_KEY, theme.getClass().getName());
            FileWriter fileWriter = new FileWriter(ThemeManager.getPropertyFile());
            properties.store(fileWriter, "Theme stored");
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File getPropertyFile() throws IOException {
        File file = new File(PROP_FILE);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    public static Theme getCurrentTheme() {
        try {
            FileReader fileReader = new FileReader(ThemeManager.getPropertyFile());
            Properties properties = new Properties();
            properties.load(fileReader);
            String string = properties.getProperty(THEME_KEY);
            Class<?> clazz = Class.forName(string);
            return (Theme)clazz.newInstance();
        }
        catch (Exception exception) {
            return new DarkTheme();
        }
    }

    public static String[] getThemes() {
        return themes;
    }

    public static int getThemeIndexFrom(Theme theme) {
        if (theme instanceof DarkTheme) {
            return 1;
        }
        return 0;
    }

    public static Theme getThemeFrom(int n) {
        switch (n) {
            case 0: {
                return new LightTheme();
            }
        }
        return new DarkTheme();
    }
}

