/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.panel.chart;

import com.google.classyshark.gui.GuiMode;
import com.google.classyshark.gui.panel.FileTransferHandler;
import com.google.classyshark.gui.panel.ViewerController;
import com.google.classyshark.gui.panel.chart.RingChart;
import com.google.classyshark.silverghost.methodscounter.ClassNode;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class RingChartPanel
extends JPanel {
    private RingChart ringChart = new RingChart();
    private ClassNode rootNode;

    public RingChartPanel(final ViewerController viewerController) {
        ToolTipManager.sharedInstance().registerComponent(this);
        GuiMode.getTheme().applyTo(this);
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ClassNode classNode = RingChartPanel.this.ringChart.getSelectedNode();
                ClassNode classNode2 = RingChartPanel.this.ringChart.getClassNodeAt(mouseEvent.getX(), mouseEvent.getY());
                if (classNode2 == null && classNode == null) {
                    return;
                }
                if (classNode2 == null || !classNode2.equals(classNode)) {
                    RingChartPanel.this.ringChart.setSelectedNode(classNode2);
                    RingChartPanel.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ClassNode classNode = RingChartPanel.this.ringChart.getClassNodeAt(mouseEvent.getX(), mouseEvent.getY());
                if (classNode == null) {
                    return;
                }
                if (classNode.getChildNodes() != null && !classNode.getChildNodes().isEmpty()) {
                    viewerController.onSelectedMethodCount(classNode);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.setTransferHandler(new FileTransferHandler(viewerController));
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        ClassNode classNode = this.ringChart.getClassNodeAt(n2, n = mouseEvent.getY());
        if (classNode == null) {
            return null;
        }
        return classNode.getKey() + ": " + classNode.getMethodCount();
    }

    public void setRootNode(ClassNode classNode) {
        this.rootNode = classNode;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.rootNode != null) {
            this.ringChart.render(this.getWidth(), this.getHeight(), this.rootNode, graphics);
        }
    }
}

