/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.panel.chart;

import com.google.classyshark.gui.GuiMode;
import com.google.classyshark.silverghost.methodscounter.ClassNode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class RingChart {
    private static final int MARGIN = 20;
    private static final int DEFAULT_MAX_DEPTH = 2;
    private Color OTHERS_COLOR = Color.GRAY;
    private static final Color[] PALETTE = new Color[]{new Color(0x5DA5DA), new Color(16426042), new Color(6339944), new Color(15826096), new Color(11702575), new Color(11695794), new Color(14602047), new Color(15816788), new Color(0x4D4D4D)};
    private static final Color[][] L2_PALLETES = new Color[][]{{new Color(6144473), new Color(6142169), new Color(6139865), new Color(6137305), new Color(6135001), new Color(6132697), new Color(6130137)}, {new Color(16414777), new Color(16418361), new Color(16422201), new Color(16425785), new Color(16429625), new Color(16433209), new Color(16437049)}, {new Color(7191904), new Color(6733152), new Color(6339937), new Color(6339944), new Color(6339951), new Color(6339958), new Color(6339965)}, {new Color(15891660), new Color(15891651), new Color(15891642), new Color(15891633), new Color(15891624), new Color(15891615), new Color(15891606)}, {new Color(11760686), new Color(11763246), new Color(11765806), new Color(11768110), new Color(11770670), new Color(11773230), new Color(11775790)}, {new Color(10843827), new Color(11105971), new Color(11433651), new Color(11761331), new Color(11761326), new Color(11761321), new Color(11761317)}, {new Color(14592574), new Color(14595646), new Color(14598718), new Color(14601790), new Color(14604862), new Color(14081598), new Color(13295166)}, {new Color(15881587), new Color(15881575), new Color(15881563), new Color(15882837), new Color(15885909), new Color(15888981), new Color(15891797)}, {new Color(0x5C5C5C), new Color(0x666666), new Color(0x707070), new Color(0x7A7A7A), new Color(0x858585), new Color(0x8F8F8F), new Color(0x999999)}};
    private int maxDepth;
    private Map<Integer, ClassNode> colorClassNodeMap = new HashMap<Integer, ClassNode>();
    private BufferedImage image;
    private ClassNode selectedNode;

    public RingChart() {
        this(2);
    }

    public RingChart(int n) {
        this.maxDepth = n;
    }

    public void setSelectedNode(ClassNode classNode) {
        this.selectedNode = classNode;
    }

    public ClassNode getSelectedNode() {
        return this.selectedNode;
    }

    public void render(int n, int n2, ClassNode classNode, Graphics graphics) {
        this.image = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setColor(GuiMode.getTheme().getBackgroundColor());
        graphics2D.fillRect(0, 0, n, n2);
        int n3 = n - 40;
        int n4 = n2 - 40;
        graphics2D.translate(20, 20);
        int n5 = Math.min(n3, n4);
        this.renderNode(n3, n4, n5, 0, 360, classNode, graphics2D, 1, PALETTE);
        graphics2D.dispose();
        graphics.drawImage(this.image, 0, 0, null);
        graphics.dispose();
    }

    public ClassNode getClassNodeAt(int n, int n2) {
        if (this.image == null) {
            return null;
        }
        int n3 = this.image.getRGB(n, n2);
        return this.colorClassNodeMap.get(n3);
    }

    private void renderNode(int n, int n2, int n3, int n4, int n5, ClassNode classNode, Graphics2D graphics2D, int n6, Color[] colorArray) {
        if (classNode.getChildNodes().isEmpty()) {
            return;
        }
        int n7 = n4;
        int n8 = n5 - n4;
        int n9 = n3 / this.maxDepth * n6;
        int n10 = (n - n9) / 2;
        int n11 = (n2 - n9) / 2;
        int n12 = 0;
        int n13 = 0;
        ArrayList<ClassNode> arrayList = new ArrayList<ClassNode>(classNode.getChildNodes().values());
        Collections.sort(arrayList, new Comparator<ClassNode>(){

            @Override
            public int compare(ClassNode classNode, ClassNode classNode2) {
                return Integer.compare(classNode2.getMethodCount(), classNode.getMethodCount());
            }
        });
        while (n7 < n5) {
            Object object;
            ClassNode classNode2 = (ClassNode)arrayList.get(n12);
            int n14 = n7;
            String string = classNode2.getKey();
            Color color = colorArray[n13];
            n7 = (int)((double)classNode2.getMethodCount() / (double)classNode.getMethodCount() * (double)n8 + (double)n7);
            if (n12 == arrayList.size() - 1) {
                n7 = n5;
            } else if (n13 == colorArray.length - 1 || 360 - n7 < 5) {
                n13 = colorArray.length - 1;
                n7 = n5;
                string = "Others";
                color = this.OTHERS_COLOR;
            }
            if (this.selectedNode != null && classNode2 == this.selectedNode) {
                color = this.getHighlightColor(color);
            }
            if (color != this.OTHERS_COLOR) {
                this.colorClassNodeMap.put(color.getRGB(), classNode2);
            }
            if (n6 < this.maxDepth && n13 != colorArray.length - 1) {
                object = L2_PALLETES[n13];
                this.renderNode(n, n2, n3, n14, n7, classNode2, graphics2D, n6 + 1, (Color[])object);
            }
            graphics2D.setColor(color);
            graphics2D.fillArc(n10, n11, n9, n9, n14, n7 - n14);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawArc(n10, n11, n9, n9, n14, n7 - n14);
            object = graphics2D.getTransform();
            int n15 = n / 2;
            int n16 = n2 / 2;
            graphics2D.translate(n15, n16);
            double d = Math.toRadians(n7);
            int n17 = (int)Math.round(Math.sin(d) * (double)(n9 / 2)) * -1;
            int n18 = (int)Math.round(Math.cos(d) * (double)(n9 / 2));
            graphics2D.drawLine(0, 0, n18, n17);
            int n19 = n3 / this.maxDepth * (n6 - 1);
            n19 = n9 + (n19 - n9) / 2;
            d = Math.toRadians(n14 + (n7 - n14) / 2);
            n17 = (int)Math.round(Math.sin(d) * (double)(n19 / 2)) * -1;
            n18 = (int)Math.round(Math.cos(d) * (double)(n19 / 2));
            graphics2D.drawString(string, n18, n17);
            graphics2D.setTransform((AffineTransform)object);
            ++n12;
            ++n13;
        }
    }

    private Color getHighlightColor(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(fArray[0], fArray[1] * 0.7f, fArray[2]);
    }
}

