/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.panel;

import com.google.classyshark.gui.panel.ArchiveDisplayer;
import com.google.classyshark.gui.panel.io.CurrentFolderConfig;
import com.google.classyshark.gui.panel.io.FileChooserUtils;
import com.google.classyshark.gui.panel.io.RecentArchivesConfig;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class FileTransferHandler
extends TransferHandler {
    private final ArchiveDisplayer archiveDisplayer;

    public FileTransferHandler(ArchiveDisplayer archiveDisplayer) {
        this.archiveDisplayer = archiveDisplayer;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        return transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        try {
            List list = (List)transferSupport.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            if (list.size() < 1) {
                return false;
            }
            for (Object e : list) {
                File file = (File)e;
                if (!FileChooserUtils.isSupportedArchiveFile(file)) continue;
                CurrentFolderConfig.INSTANCE.setCurrentDirectory(file.getParentFile());
                RecentArchivesConfig.INSTANCE.addArchive(file.getName(), file.getParentFile());
                this.archiveDisplayer.displayArchive(file);
            }
            return true;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

