/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.util.output;

import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.state.TypeUsageInformation;
import org.benf.cfr.reader.util.Troolean;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.output.Dumper;
import org.benf.cfr.reader.util.output.DumperFactory;
import org.benf.cfr.reader.util.output.FileDumper;
import org.benf.cfr.reader.util.output.FileSummaryDumper;
import org.benf.cfr.reader.util.output.IllegalIdentifierDump;
import org.benf.cfr.reader.util.output.NopSummaryDumper;
import org.benf.cfr.reader.util.output.StdIODumper;
import org.benf.cfr.reader.util.output.SummaryDumper;

public class DumperFactoryImpl
implements DumperFactory {
    private static Pair<String, Boolean> getPathAndClobber(Options options) {
        Troolean clobber = (Troolean)((Object)options.getOption(OptionsImpl.CLOBBER_FILES));
        if (options.optionIsSet(OptionsImpl.OUTPUT_DIR)) {
            return Pair.make(options.getOption(OptionsImpl.OUTPUT_DIR), clobber.boolValue(true));
        }
        if (options.optionIsSet(OptionsImpl.OUTPUT_PATH)) {
            return Pair.make(options.getOption(OptionsImpl.OUTPUT_PATH), clobber.boolValue(false));
        }
        return null;
    }

    @Override
    public Dumper getNewTopLevelDumper(Options options, JavaTypeInstance classType, SummaryDumper summaryDumper, TypeUsageInformation typeUsageInformation, IllegalIdentifierDump illegalIdentifierDump) {
        Pair<String, Boolean> targetInfo = DumperFactoryImpl.getPathAndClobber(options);
        if (targetInfo == null) {
            return new StdIODumper(typeUsageInformation, options, illegalIdentifierDump);
        }
        return new FileDumper(targetInfo.getFirst(), targetInfo.getSecond(), classType, summaryDumper, typeUsageInformation, options, illegalIdentifierDump);
    }

    @Override
    public SummaryDumper getSummaryDumper(Options options) {
        Pair<String, Boolean> targetInfo = DumperFactoryImpl.getPathAndClobber(options);
        if (targetInfo == null) {
            return new NopSummaryDumper();
        }
        return new FileSummaryDumper(targetInfo.getFirst());
    }
}

