/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.util.getopt;

import java.util.List;
import java.util.Map;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.getopt.BadParametersException;
import org.benf.cfr.reader.util.getopt.GetOptSinkFactory;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.getopt.PermittedOptionProvider;

public class GetOptParser {
    public static String getHelp(PermittedOptionProvider permittedOptionProvider) {
        StringBuilder sb = new StringBuilder();
        for (String flag : permittedOptionProvider.getFlags()) {
            sb.append("   --").append(flag).append("\n");
        }
        int max = 10;
        for (PermittedOptionProvider.ArgumentParam<?, ?> param : permittedOptionProvider.getArguments()) {
            int len = param.getName().length();
            max = len > max ? len : max;
        }
        max += 4;
        for (PermittedOptionProvider.ArgumentParam<?, ?> param : permittedOptionProvider.getArguments()) {
            if (param.isHidden()) continue;
            String name = param.getName();
            int pad = max - name.length();
            sb.append("   --").append(param.getName());
            for (int x = 0; x < pad; ++x) {
                sb.append(' ');
            }
            sb.append(param.shortDescribe()).append("\n");
        }
        return sb.toString();
    }

    private static Map<String, OptData> buildOptTypeMap(PermittedOptionProvider optionProvider) {
        Map<String, OptData> optTypeMap = MapFactory.newMap();
        for (String string : optionProvider.getFlags()) {
            optTypeMap.put(string, new OptData(string));
        }
        for (PermittedOptionProvider.ArgumentParam argumentParam : optionProvider.getArguments()) {
            optTypeMap.put(argumentParam.getName(), new OptData(argumentParam));
        }
        return optTypeMap;
    }

    public <T> T parse(String[] args, GetOptSinkFactory<T> getOptSinkFactory) {
        Pair<List<String>, Map<String, String>> processed = this.process(args, getOptSinkFactory);
        return getOptSinkFactory.create(processed.getFirst(), processed.getSecond());
    }

    private static void printErrHeader() {
        System.err.println("CFR 0_115\n");
    }

    private static void printUsage() {
        System.err.println("java --jar cfr_0_115.jar class_or_jar_file [method] [options]\n");
    }

    public <T> void showHelp(PermittedOptionProvider permittedOptionProvider) {
        GetOptParser.printErrHeader();
        GetOptParser.printUsage();
        System.err.println(GetOptParser.getHelp(permittedOptionProvider));
    }

    public <T> void showHelp(PermittedOptionProvider permittedOptionProvider, Exception e) {
        GetOptParser.printErrHeader();
        GetOptParser.printUsage();
        System.err.println("Parameter error : " + e.toString() + "\n");
        System.err.println(GetOptParser.getHelp(permittedOptionProvider));
    }

    public <T> void showOptionHelp(PermittedOptionProvider permittedOptionProvider, Options options, PermittedOptionProvider.ArgumentParam<String, Void> helpArg) {
        GetOptParser.printErrHeader();
        String relevantOption = options.getOption(helpArg);
        List<PermittedOptionProvider.ArgumentParam<?, ?>> possible = permittedOptionProvider.getArguments();
        for (PermittedOptionProvider.ArgumentParam<?, ?> opt : possible) {
            if (!opt.getName().equals(relevantOption)) continue;
            System.err.println(opt.describe());
            return;
        }
        System.err.println(GetOptParser.getHelp(permittedOptionProvider));
        System.err.println("No such argument '" + relevantOption + "'");
    }

    private Pair<List<String>, Map<String, String>> process(String[] in, PermittedOptionProvider optionProvider) {
        Map<String, OptData> optTypeMap = GetOptParser.buildOptTypeMap(optionProvider);
        Map<String, String> res = MapFactory.newMap();
        List positional = ListFactory.newList();
        OptionsImpl optionsSample = new OptionsImpl("", "", res);
        for (int x = 0; x < in.length; ++x) {
            if (in[x].startsWith("--")) {
                String name = in[x].substring(2);
                OptData optData = optTypeMap.get(name);
                if (optData == null) {
                    throw new IllegalArgumentException("Unknown argument " + name);
                }
                if (optData.isFlag()) {
                    res.put(name, null);
                    continue;
                }
                if (x >= in.length - 1) {
                    throw new BadParametersException("Requires argument", optData.getArgument());
                }
                res.put(name, in[++x]);
                try {
                    optData.getArgument().getFn().invoke(res.get(name), null, optionsSample);
                    continue;
                }
                catch (Exception e) {
                    throw new BadParametersException(e.toString(), optData.getArgument());
                }
            }
            positional.add(in[x]);
        }
        return Pair.make(positional, res);
    }

    private static class OptData {
        private final boolean isFlag;
        private final String name;
        private final PermittedOptionProvider.ArgumentParam<?, ?> argument;

        private OptData(String name) {
            this.name = name;
            this.isFlag = true;
            this.argument = null;
        }

        private OptData(PermittedOptionProvider.ArgumentParam<?, ?> argument) {
            this.argument = argument;
            this.isFlag = false;
            this.name = argument.getName();
        }

        public boolean isFlag() {
            return this.isFlag;
        }

        public String getName() {
            return this.name;
        }

        public PermittedOptionProvider.ArgumentParam<?, ?> getArgument() {
            return this.argument;
        }
    }
}

