/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.entities.classfilehelpers;

import java.util.List;
import org.benf.cfr.reader.bytecode.analysis.types.ClassSignature;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.entities.AccessFlag;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.ClassFileField;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper;
import org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumper;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.util.output.Dumper;

public class ClassFileDumperNormal
extends AbstractClassFileDumper {
    private static final AccessFlag[] dumpableAccessFlagsClass = new AccessFlag[]{AccessFlag.ACC_PUBLIC, AccessFlag.ACC_PRIVATE, AccessFlag.ACC_PROTECTED, AccessFlag.ACC_STRICT, AccessFlag.ACC_STATIC, AccessFlag.ACC_FINAL, AccessFlag.ACC_ABSTRACT};
    private static final AccessFlag[] dumpableAccessFlagsInlineClass = new AccessFlag[]{AccessFlag.ACC_PUBLIC, AccessFlag.ACC_PRIVATE, AccessFlag.ACC_PROTECTED, AccessFlag.ACC_STRICT, AccessFlag.ACC_FINAL, AccessFlag.ACC_ABSTRACT};

    public ClassFileDumperNormal(DCCommonState dcCommonState) {
        super(dcCommonState);
    }

    private void dumpHeader(ClassFile c, ClassFileDumper.InnerClassDumpType innerClassDumpType, Dumper d) {
        List<JavaTypeInstance> interfaces;
        AccessFlag[] accessFlagsToDump = innerClassDumpType == ClassFileDumper.InnerClassDumpType.INLINE_CLASS ? dumpableAccessFlagsInlineClass : dumpableAccessFlagsClass;
        d.print(ClassFileDumperNormal.getAccessFlagsString(c.getAccessFlags(), accessFlagsToDump));
        ClassSignature signature = c.getClassSignature();
        d.print("class ").dump(c.getThisClassConstpoolEntry().getTypeInstance());
        ClassFileDumperNormal.getFormalParametersText(signature, d);
        d.print("\n");
        JavaTypeInstance superClass = signature.getSuperClass();
        if (superClass != null && !superClass.getRawName().equals("java.lang.Object")) {
            d.print("extends ").dump(superClass).print("\n");
        }
        if (!(interfaces = signature.getInterfaces()).isEmpty()) {
            d.print("implements ");
            int size = interfaces.size();
            for (int x = 0; x < size; ++x) {
                JavaTypeInstance iface = interfaces.get(x);
                d.dump(iface).print(x < size - 1 ? ",\n" : "\n");
            }
        }
        d.removePendingCarriageReturn().print(" ");
    }

    @Override
    public Dumper dump(ClassFile classFile, ClassFileDumper.InnerClassDumpType innerClass, Dumper d) {
        if (!d.canEmitClass(classFile.getClassType())) {
            return d;
        }
        if (!innerClass.isInnerClass()) {
            this.dumpTopHeader(classFile, d);
            this.dumpImports(d, classFile);
        }
        this.dumpComments(classFile, d);
        this.dumpAnnotations(classFile, d);
        this.dumpHeader(classFile, innerClass, d);
        d.print("{\n");
        d.indent(1);
        boolean first = true;
        List<ClassFileField> fields = classFile.getFields();
        for (ClassFileField field : fields) {
            if (field.shouldNotDisplay()) continue;
            field.dump(d);
            first = false;
        }
        List<Method> methods = classFile.getMethods();
        if (!methods.isEmpty()) {
            for (Method method : methods) {
                if (method.isHiddenFromDisplay()) continue;
                if (!first) {
                    d.newln();
                }
                first = false;
                method.dump(d, true);
            }
        }
        classFile.dumpNamedInnerClasses(d);
        d.indent(-1);
        d.print("}\n");
        return d;
    }

    @Override
    public void collectTypeUsages(TypeUsageCollector collector) {
    }
}

