/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.optimizer;

import java.util.HashMap;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingMethodAdapter;
import org.objectweb.asm.optimizer.ClassOptimizer;

public class MethodOptimizer
extends RemappingMethodAdapter
implements Opcodes {
    private final ClassOptimizer classOptimizer;
    private static final HashMap<String, String[]> BOXING_MAP;

    public MethodOptimizer(ClassOptimizer classOptimizer, int access, String desc, MethodVisitor mv, Remapper remapper) {
        super(327680, access, desc, mv, remapper);
        this.classOptimizer = classOptimizer;
    }

    public void visitParameter(String name, int access) {
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return null;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return null;
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    public void visitLineNumber(int line, Label start) {
    }

    public void visitFrame(int type, int local, Object[] local2, int stack, Object[] stack2) {
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitLdcInsn(Object cst) {
        String fieldName;
        if (!(cst instanceof Type)) {
            super.visitLdcInsn(cst);
            return;
        }
        String ldcName = ((Type)cst).getInternalName();
        String string = String.valueOf(ldcName.replace('/', '$'));
        String string2 = fieldName = string.length() != 0 ? "class$".concat(string) : new String("class$");
        if (!this.classOptimizer.syntheticClassFields.contains(ldcName)) {
            this.classOptimizer.syntheticClassFields.add(ldcName);
            FieldVisitor fv = this.classOptimizer.syntheticFieldVisitor(4104, fieldName, "Ljava/lang/Class;");
            fv.visitEnd();
        }
        String clsName = this.classOptimizer.clsName;
        this.mv.visitFieldInsn(178, clsName, fieldName, "Ljava/lang/Class;");
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (opcode == 184 && name.equals("valueOf")) {
            String string = String.valueOf(owner);
            String string2 = String.valueOf(desc);
            String[] constructorParams = BOXING_MAP.get(string2.length() != 0 ? string.concat(string2) : new String(string));
            if (constructorParams != null) {
                String type = constructorParams[0];
                String initDesc = constructorParams[1];
                super.visitTypeInsn(187, type);
                super.visitInsn(89);
                super.visitInsn(initDesc == "(J)V" || initDesc == "(D)V" ? 94 : 93);
                super.visitInsn(88);
                super.visitMethodInsn(183, type, "<init>", initDesc, false);
                return;
            }
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    static {
        String[][] boxingNames = new String[][]{{"java/lang/Byte", "(B)V"}, {"java/lang/Short", "(S)V"}, {"java/lang/Character", "(C)V"}, {"java/lang/Integer", "(I)V"}, {"java/lang/Long", "(J)V"}, {"java/lang/Float", "(F)V"}, {"java/lang/Double", "(D)V"}};
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String[] boxingName : boxingNames) {
            String wrapper = boxingName[0];
            String desc = boxingName[1];
            char c = desc.charAt(1);
            String boxingMethod = new StringBuilder(5 + String.valueOf(wrapper).length() + String.valueOf(wrapper).length()).append(wrapper).append("(").append(c).append(")L").append(wrapper).append(";").toString();
            map.put(boxingMethod, boxingName);
        }
        BOXING_MAP = map;
    }
}

