/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jack.google.common.base.Splitter;
import com.android.jack.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public final class VPath
implements Cloneable {
    @Nonnull
    public static final VPath ROOT = new VPath("", '/');
    private static final char INTERNAL_SEPARATOR = '/';
    private static final VPathFragment INTERNAL_SEPARATOR_FRAGMENT = new VPathFragment(String.valueOf('/'), '/');
    @Nonnull
    private static final Splitter splitter = Splitter.on('/').omitEmptyStrings();
    @Nonnull
    ArrayList<VPathFragment> pathFragments;

    public VPath(@Nonnull CharSequence path, char separator) {
        this.pathFragments = new ArrayList(1);
        if (path.length() > 0) {
            VPathFragment pe = new VPathFragment(path, separator);
            assert (pe.isValidPath());
            this.pathFragments.add(pe);
        }
    }

    private VPath(ArrayList<VPathFragment> pathFragments) {
        this.pathFragments = pathFragments;
    }

    public VPath prependPath(@Nonnull VPath path) {
        assert (!path.isRoot());
        if (!this.isRoot()) {
            this.pathFragments.add(0, INTERNAL_SEPARATOR_FRAGMENT);
        }
        this.pathFragments.addAll(0, path.getPathFragments());
        return this;
    }

    public VPath appendPath(@Nonnull VPath path) {
        assert (!path.isRoot());
        if (!this.isRoot()) {
            this.pathFragments.add(INTERNAL_SEPARATOR_FRAGMENT);
        }
        this.pathFragments.addAll(path.getPathFragments());
        return this;
    }

    public VPath addSuffix(@Nonnull CharSequence suffix) {
        VPathFragment pe = new VPathFragment(suffix, '/');
        assert (pe.isValidSuffix());
        this.pathFragments.add(pe);
        return this;
    }

    public VPath clone() {
        ArrayList clonedList = (ArrayList)this.pathFragments.clone();
        return new VPath(clonedList);
    }

    @Nonnull
    public Iterable<String> split() {
        return splitter.split(this.getInternalPath());
    }

    @Nonnull
    public String getPathAsString(char separator) {
        StringBuffer buffer = new StringBuffer();
        for (VPathFragment pathElement : this.pathFragments) {
            buffer.append(pathElement.getPathElementAsString(separator));
        }
        return buffer.toString();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof VPath)) {
            return false;
        }
        return this.getInternalPath().equals(((VPath)obj).getInternalPath());
    }

    public final int hashCode() {
        return this.getInternalPath().hashCode();
    }

    @Nonnull
    private List<VPathFragment> getPathFragments() {
        return this.pathFragments;
    }

    @Nonnull
    private String getInternalPath() {
        return this.getPathAsString('/');
    }

    public boolean isRoot() {
        return this.pathFragments.isEmpty();
    }

    @Nonnull
    public String getLastName() {
        return Iterators.getLast(this.split().iterator(), "");
    }

    private static class VPathFragment {
        @Nonnull
        private final CharSequence path;
        private final char separator;

        public VPathFragment(@Nonnull CharSequence path, char separator) {
            this.path = path;
            this.separator = separator;
        }

        @Nonnull
        public String getPathElementAsString(char separator) {
            return this.path.toString().replace(this.separator, separator);
        }

        private boolean isValidPath() {
            String stringSeparator;
            String doubleSeparator;
            String toString = this.path.toString();
            if (toString.contains(doubleSeparator = (stringSeparator = String.valueOf(this.separator)) + this.separator)) {
                throw new AssertionError((Object)("Path: " + toString));
            }
            if (toString.startsWith(stringSeparator)) {
                throw new AssertionError((Object)("Path: " + toString));
            }
            if (toString.endsWith(stringSeparator)) {
                throw new AssertionError((Object)("Path: " + toString));
            }
            return true;
        }

        private boolean isValidSuffix() {
            return this.path.toString().indexOf(this.separator) == -1;
        }
    }
}

