/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer;

import com.android.sched.util.codec.ImplementationSelector;
import com.android.sched.util.codec.ListCodec;
import com.android.sched.util.collect.Lists;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.EventType;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.ThreadTracerState;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import com.android.sched.util.log.tracer.DynamicEventType;
import com.android.sched.util.log.tracer.ProbeManager;
import com.android.sched.util.log.tracer.TracerEventType;
import com.android.sched.util.log.tracer.probe.HeapAllocationProbe;
import com.android.sched.util.log.tracer.probe.Probe;
import com.android.sched.util.log.tracer.watcher.ObjectWatcher;
import com.android.sched.util.log.tracer.watcher.WatcherInstaller;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@HasKeyId
public abstract class AbstractTracer
implements Tracer {
    @Nonnull
    public static final PropertyId<List<WatcherInstaller>> WATCHER_INSTALL = PropertyId.create("sched.tracer.watchers", "Define which watchers use for tracing", new ListCodec<WatcherInstaller>(new ImplementationSelector<WatcherInstaller>(WatcherInstaller.class)).setMin(0).ensureUnicity()).addDefaultValue((WatcherInstaller)((Object)""));
    @Nonnull
    public static final BooleanPropertyId PARENT_THREAD_SUPORT = BooleanPropertyId.create("sched.tracer.thread", "If tracer follows parent thread creation").addDefaultValue(true);
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();
    private final boolean parentThreadSupport = ThreadConfig.get(PARENT_THREAD_SUPORT);
    private final Map<Class<? extends ObjectWatcher<?>>, WeakHashMap<Object, ObjectWatcher<Object>>> objects = new HashMap();
    private final Map<Class<?>, Class<? extends ObjectWatcher<?>>> watchers = new HashMap();
    private final Set<Class<?>> notWatched = new HashSet();
    private final Object watcherLock = new Object();
    @Nonnull
    protected final ProbeManager probeManager = ProbeManager.getProbeManager();
    @Nonnull
    protected final Map<EventType, Map<StatisticId<? extends Statistic>, Statistic>[]> globalStatistics = new HashMap<EventType, Map<StatisticId<? extends Statistic>, Statistic>[]>();
    @Nonnull
    private final Set<StatisticId<? extends Statistic>> setOfStatisticIds = new HashSet<StatisticId<? extends Statistic>>();
    @Nonnull
    private final Map<String, DynamicEventType> dynamicEventByName = new HashMap<String, DynamicEventType>();
    @Nonnull
    private final BlockingQueue<TracerEvent> eventsToWrite;
    @Nonnull
    private final ThreadLocal<Stack<TracerEvent>> pendingEvents;
    @Nonnull
    private final CountDownLatch shutDownLatch;
    @Nonnull
    private final TracerEvent shutDownSentinel;
    @Nonnull
    private final AtomicInteger eventCount = new AtomicInteger(0);

    public AbstractTracer() {
        this.eventsToWrite = this.openQueue();
        this.shutDownSentinel = new TracerEvent();
        this.shutDownLatch = new CountDownLatch(1);
        this.pendingEvents = this.initPendingEvents();
        List<WatcherInstaller> watchers = ThreadConfig.get(WATCHER_INSTALL);
        if (watchers.size() > 0) {
            for (WatcherInstaller watcher : watchers) {
                watcher.install(this);
            }
            HeapAllocationProbe.ensureInstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <T> void registerWatcher(@Nonnull Class<T> objectClass, @Nonnull Class<? extends ObjectWatcher<? extends T>> watcherClass) {
        WeakHashMap map = new WeakHashMap();
        Object object = this.watcherLock;
        synchronized (object) {
            this.objects.put(watcherClass, map);
            this.watchers.put(objectClass, watcherClass);
            for (Class<?> cls : this.notWatched) {
                if (!objectClass.isAssignableFrom(cls)) continue;
                this.logger.log(Level.INFO, "Watcher ''{0}'' missed some instances of type ''{1}''", new Object[]{watcherClass.getName(), cls.getName()});
                this.watchers.put(cls, watcherClass);
                this.notWatched.remove(objectClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObject(@Nonnull Object object, @Nonnegative long size, int count, @CheckForNull StackTraceElement site) {
        Class<ObjectWatcher<?>> watcherClass = null;
        Object object2 = this.watcherLock;
        synchronized (object2) {
            if (this.notWatched.contains(object.getClass())) {
                return;
            }
            watcherClass = this.watchers.get(object.getClass());
            if (watcherClass == null) {
                for (Map.Entry<Class<?>, Class<ObjectWatcher<?>>> entry : this.watchers.entrySet()) {
                    if (!entry.getKey().isAssignableFrom(object.getClass())) continue;
                    watcherClass = entry.getValue();
                    break;
                }
                if (watcherClass != null) {
                    this.watchers.put(object.getClass(), watcherClass);
                } else {
                    this.notWatched.add(object.getClass());
                    return;
                }
            }
            try {
                ObjectWatcher<?> watcher = watcherClass.newInstance();
                WeakHashMap<Object, ObjectWatcher<Object>> weak = this.objects.get(watcherClass);
                assert (weak != null);
                if (watcher.notifyInstantiation(object, size, count, this.getCurrentEventType(), site)) {
                    weak.put(object, watcher);
                }
            }
            catch (InstantiationException e) {
                this.logger.log(Level.WARNING, "Can not instantiate Watcher", e);
            }
            catch (IllegalAccessException e) {
                this.logger.log(Level.WARNING, "Can not instantiate Watcher", e);
            }
        }
    }

    abstract void stopTracer();

    abstract void processEvent(@Nonnull Event var1);

    abstract void flush();

    @Override
    @Nonnull
    public <T extends Statistic> T getStatistic(@Nonnull StatisticId<T> id) {
        Stack<TracerEvent> threadPendingEvents = this.pendingEvents.get();
        if (threadPendingEvents.isEmpty()) {
            throw new IllegalStateException("Tried to get statistic to an event that never started!");
        }
        return threadPendingEvents.peek().getStatistic(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeStatistic(@Nonnull EventType type, @Nonnull StatisticId<? extends Statistic> id, @Nonnull Children kind, @Nonnull Statistic local) {
        Statistic global;
        Map<StatisticId<? extends Statistic>, Statistic>[] staticticById;
        Map<EventType, Map<StatisticId<? extends Statistic>, Statistic>[]> map = this.globalStatistics;
        synchronized (map) {
            staticticById = this.globalStatistics.get(type);
            if (staticticById == null) {
                staticticById = new Map[Children.values().length];
                this.globalStatistics.put(type, staticticById);
                for (int i = 0; i < staticticById.length; ++i) {
                    staticticById[i] = new HashMap<StatisticId<? extends Statistic>, Statistic>();
                }
            }
        }
        Object object = staticticById[kind.ordinal()];
        synchronized (object) {
            global = staticticById[kind.ordinal()].get(id);
            if (global == null) {
                global = id.newInstance();
                staticticById[kind.ordinal()].put(id, global);
                Set<StatisticId<? extends Statistic>> set = this.setOfStatisticIds;
                synchronized (set) {
                    this.setOfStatisticIds.add(id);
                }
            }
        }
        object = global;
        synchronized (object) {
            global.merge(local);
        }
    }

    @Nonnull
    protected Collection<StatisticId<? extends Statistic>> getStatisticsIds() {
        return this.setOfStatisticIds;
    }

    @Override
    @Nonnull
    public TracerEvent open(@Nonnull String name) {
        return this.open(this.getOrCreateDynamicEventType(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EventType getDynamicEventType(@Nonnull String name) {
        Map<String, DynamicEventType> map = this.dynamicEventByName;
        synchronized (map) {
            EventType type = this.dynamicEventByName.get(name);
            if (type != null) {
                return type;
            }
            return TracerEventType.NOTYPE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private EventType getOrCreateDynamicEventType(@Nonnull String name) {
        Map<String, DynamicEventType> map = this.dynamicEventByName;
        synchronized (map) {
            DynamicEventType type = this.dynamicEventByName.get(name);
            if (type == null) {
                type = new DynamicEventType(name);
                this.dynamicEventByName.put(name, type);
            }
            return type;
        }
    }

    @Override
    @Nonnull
    public TracerEvent open(@Nonnull EventType type) {
        this.eventCount.incrementAndGet();
        Stack<TracerEvent> threadPendingEvents = this.pendingEvents.get();
        TracerEvent parent = null;
        if (!threadPendingEvents.isEmpty()) {
            parent = threadPendingEvents.peek();
        }
        TracerEvent newEvent = new TracerEvent(parent, type);
        threadPendingEvents.push(newEvent);
        return newEvent;
    }

    @Override
    @Nonnull
    public ThreadTracerState getThreadState() {
        return this.parentThreadSupport ? new ThreadTracerStateImpl() : ThreadTracerStateDummy.INSTANCE;
    }

    @Override
    public void pushThreadState(@Nonnull ThreadTracerState state) {
        if (this.parentThreadSupport) {
            EventType[] types = ((ThreadTracerStateImpl)state).types;
            for (int idx = 0; idx < types.length; ++idx) {
                this.open(types[idx]);
            }
        }
    }

    @Override
    public void popThreadState(@Nonnull ThreadTracerState state) {
        if (this.parentThreadSupport) {
            Stack<TracerEvent> stack = this.pendingEvents.get();
            assert (((ThreadTracerStateImpl)state).types.length == stack.size());
            for (int idx = stack.size() - 1; idx >= 0; --idx) {
                assert (((ThreadTracerStateImpl)state).types[idx] == stack.peek().getType());
                stack.peek().close();
            }
        }
    }

    @Override
    public boolean isTracing() {
        return this.probeManager.isStarted();
    }

    @Nonnull
    ProbeManager getProbeManager() {
        return this.probeManager;
    }

    @Override
    @Nonnull
    public EventType getCurrentEventType() {
        Stack<TracerEvent> threadPendingEvents = this.pendingEvents.get();
        if (threadPendingEvents.isEmpty()) {
            return TracerEventType.NOEVENT;
        }
        return threadPendingEvents.peek().getType();
    }

    @Nonnull
    private ThreadLocal<Stack<TracerEvent>> initPendingEvents() {
        return new ThreadLocal<Stack<TracerEvent>>(){

            @Override
            protected Stack<TracerEvent> initialValue() {
                return new Stack<TracerEvent>();
            }
        };
    }

    @Nonnull
    private BlockingQueue<TracerEvent> openQueue() {
        LinkedBlockingQueue<TracerEvent> eventQueue = new LinkedBlockingQueue<TracerEvent>();
        LogWriterThread logWriterWorker = new LogWriterThread(eventQueue);
        logWriterWorker.setPriority(3);
        logWriterWorker.setDaemon(true);
        logWriterWorker.setName("StatsLogger writer");
        logWriterWorker.start();
        return eventQueue;
    }

    private class TracerEvent
    implements Event {
        @Nonnull
        protected final EventType type;
        @Nonnull
        List<Event> children;
        @Nonnull
        long[] elapsedValue;
        @Nonnull
        long[] startValue;
        @CheckForNull
        Map<StatisticId<? extends Statistic>, Statistic> statisticsById;

        TracerEvent() {
            this.children = Lists.create();
            this.type = TracerEventType.NOTYPE;
            this.elapsedValue = new long[AbstractTracer.this.probeManager.getProbes().size()];
            this.startValue = AbstractTracer.this.probeManager.read(this.type);
        }

        TracerEvent(@Nonnull TracerEvent parent, EventType type) {
            if (parent != null) {
                AbstractTracer.this.probeManager.stop();
                parent.children = Lists.add(parent.children, this);
            }
            this.children = Lists.create();
            this.type = type;
            this.elapsedValue = new long[AbstractTracer.this.probeManager.getProbes().size()];
            this.startValue = AbstractTracer.this.probeManager.readAndStart(type);
        }

        TracerEvent(@Nonnull TracerEvent parent, @Nonnull EventType type, long[] values) {
            if (parent != null) {
                parent.children = Lists.add(parent.children, this);
            }
            this.children = Lists.create();
            this.type = type;
            this.elapsedValue = new long[AbstractTracer.this.probeManager.getProbes().size()];
            this.startValue = values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                long[] values = AbstractTracer.this.probeManager.stopAndRead(this.type);
                Stack threadPendingEvents = (Stack)AbstractTracer.this.pendingEvents.get();
                if (threadPendingEvents.isEmpty() || threadPendingEvents.peek() != this) {
                    throw new IllegalStateException("Event '" + this.getType().getName() + "' is not the current one");
                }
                TracerEvent currentEvent = (TracerEvent)threadPendingEvents.pop();
                for (int i = 0; i < values.length; ++i) {
                    currentEvent.elapsedValue[i] = values[i] - currentEvent.startValue[i];
                }
                TracerEvent[] stack = threadPendingEvents.toArray(new TracerEvent[threadPendingEvents.size()]);
                for (WeakHashMap weak : AbstractTracer.this.objects.values()) {
                    TracerEvent[] statistics = null;
                    for (Map.Entry entry : weak.entrySet()) {
                        statistics = ((ObjectWatcher)entry.getValue()).addSample(entry.getKey(), (ObjectWatcher.Statistics)statistics, currentEvent.getType());
                    }
                    if (statistics == null) continue;
                    for (Statistic statistic : statistics) {
                        AbstractTracer.this.mergeStatistic(currentEvent.getType(), statistic.getId(), Children.WITHOUT, statistic);
                        AbstractTracer.this.mergeStatistic(currentEvent.getType(), statistic.getId(), Children.WITH, statistic);
                        for (TracerEvent event : stack) {
                            if (event.getType() == currentEvent.getType()) continue;
                            AbstractTracer.this.mergeStatistic(event.getType(), statistic.getId(), Children.WITH, statistic);
                        }
                    }
                }
                for (Statistic stat : currentEvent.getStatistics()) {
                    AbstractTracer.this.mergeStatistic(currentEvent.getType(), stat.getId(), Children.WITHOUT, stat);
                    AbstractTracer.this.mergeStatistic(currentEvent.getType(), stat.getId(), Children.WITH, stat);
                    for (TracerEvent event : stack) {
                        if (event.getType() == currentEvent.getType()) continue;
                        AbstractTracer.this.mergeStatistic(event.getType(), stat.getId(), Children.WITH, stat);
                    }
                }
                currentEvent.removeStatistics();
                if (threadPendingEvents.isEmpty()) {
                    AbstractTracer.this.eventsToWrite.add(currentEvent);
                } else {
                    TracerEvent parent = (TracerEvent)threadPendingEvents.peek();
                    TracerEvent overhead = new TracerEvent(parent, TracerEventType.OVERHEAD, values);
                    long[] now = AbstractTracer.this.probeManager.readAndStart(this.type);
                    for (int idx = 0; idx < now.length; ++idx) {
                        overhead.elapsedValue[idx] = now[idx] - values[idx];
                    }
                }
            }
            finally {
                if (AbstractTracer.this.eventCount.decrementAndGet() == 0) {
                    try {
                        AbstractTracer.this.eventsToWrite.add(AbstractTracer.this.shutDownSentinel);
                        AbstractTracer.this.shutDownLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        @Override
        @Nonnull
        public Collection<Statistic> getStatistics() {
            if (this.statisticsById != null) {
                return this.statisticsById.values();
            }
            return Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        public <T extends Statistic> T getStatistic(@Nonnull StatisticId<T> id) {
            AbstractTracer.this.probeManager.stop();
            try {
                Statistic statistic;
                if (this.statisticsById == null) {
                    this.statisticsById = new HashMap<StatisticId<? extends Statistic>, Statistic>();
                }
                if ((statistic = this.statisticsById.get(id)) == null) {
                    statistic = id.newInstance();
                    this.statisticsById.put(id, statistic);
                }
                Statistic statistic2 = statistic;
                return (T)statistic2;
            }
            finally {
                AbstractTracer.this.probeManager.start();
            }
        }

        @Override
        @Nonnegative
        public long getElapsedValue(@Nonnull Probe probe) {
            return this.elapsedValue[AbstractTracer.this.probeManager.getIndex(probe)];
        }

        @Override
        @Nonnegative
        public long getStartValue(@Nonnull Probe probe) {
            return this.startValue[AbstractTracer.this.probeManager.getIndex(probe)];
        }

        @Override
        public void adjustElapsedValue(@Nonnull Probe probe, long value) {
            int n = AbstractTracer.this.probeManager.getIndex(probe);
            this.elapsedValue[n] = this.elapsedValue[n] + value;
        }

        @Override
        @Nonnull
        public EventType getType() {
            return this.type;
        }

        @Nonnull
        public String toString() {
            return this.type.getName();
        }

        @Nonnull
        public List<Event> getChildren() {
            return this.children;
        }

        private void removeStatistics() {
            this.statisticsById = null;
        }
    }

    private class LogWriterThread
    extends Thread {
        private static final int FLUSH_TIMER_MSECS = 1000;
        @Nonnull
        private final BlockingQueue<TracerEvent> threadEventQueue;

        public LogWriterThread(BlockingQueue<TracerEvent> eventQueue) {
            this.threadEventQueue = eventQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long nextFlush = System.currentTimeMillis() + 1000L;
            try {
                while (true) {
                    TracerEvent event;
                    if ((event = this.threadEventQueue.poll(nextFlush - System.currentTimeMillis(), TimeUnit.MILLISECONDS)) != null) {
                        if (event == AbstractTracer.this.shutDownSentinel) {
                            try {
                                AbstractTracer.this.stopTracer();
                            }
                            catch (Throwable e) {
                                AbstractTracer.this.logger.log(Level.SEVERE, "Problem during tracer shutdown", e);
                            }
                            break;
                        }
                        AbstractTracer.this.processEvent(event);
                    }
                    if (System.currentTimeMillis() < nextFlush) continue;
                    AbstractTracer.this.flush();
                    nextFlush = System.currentTimeMillis() + 1000L;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                AbstractTracer.this.shutDownLatch.countDown();
            }
        }
    }

    private static class ThreadTracerStateDummy
    implements ThreadTracerState {
        @Nonnull
        public static final ThreadTracerStateDummy INSTANCE = new ThreadTracerStateDummy();

        private ThreadTracerStateDummy() {
        }
    }

    private class ThreadTracerStateImpl
    implements ThreadTracerState {
        @Nonnull
        private final EventType[] types;

        private ThreadTracerStateImpl() {
            Stack stack = (Stack)AbstractTracer.this.pendingEvents.get();
            this.types = new EventType[stack.size()];
            int idx = 0;
            for (TracerEvent event : stack) {
                this.types[idx++] = event.getType();
            }
        }
    }

    protected static enum Children {
        WITH,
        WITHOUT;

    }
}

