/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.sched.util.RunnableHooks;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.NoLocation;
import com.android.sched.util.log.LoggerFactory;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class FileOrDirectory
implements HasLocation {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private static final Location NO_LOCATION = new NoLocation();
    @Nonnull
    protected Location location = NO_LOCATION;
    @CheckForNull
    private RunnableHooks hooks;
    @CheckForNull
    private Runnable remover;

    protected FileOrDirectory(@CheckForNull RunnableHooks hooks) {
        this.hooks = hooks;
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.location;
    }

    @Nonnull
    public abstract String getPath();

    public static void setPermissions(@Nonnull File file, @Nonnull Location location, int permissions, @Nonnull ChangePermission change) throws CannotChangePermissionException {
        if (change != ChangePermission.NOCHANGE) {
            if ((permissions & 1) != 0) {
                if (file.setReadable(true, change == ChangePermission.OWNER)) {
                    logger.log(Level.FINE, "Set readable permission to {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                } else {
                    logger.log(Level.FINE, "Unable to set readable permission to {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                }
            }
            if ((permissions & 2) != 0) {
                if (file.setWritable(true, change == ChangePermission.OWNER)) {
                    logger.log(Level.FINE, "Set writable permission to {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                } else {
                    logger.log(Level.FINE, "Unable to set writable permission to {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                }
            }
            if ((permissions & 4) != 0) {
                if (file.setExecutable(true, change == ChangePermission.OWNER)) {
                    logger.log(Level.FINE, "Set executable permission to {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                } else {
                    logger.log(Level.FINE, "Unable to set executable permission to {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                }
            }
        }
    }

    public static void unsetPermissions(@Nonnull File file, @Nonnull Location location, int permissions, @Nonnull ChangePermission change) throws CannotChangePermissionException {
        if (change != ChangePermission.NOCHANGE) {
            if ((permissions & 1) != 0) {
                if (file.setReadable(false, change == ChangePermission.OWNER)) {
                    logger.log(Level.FINE, "Clear readable permission to {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                } else {
                    logger.log(Level.FINE, "Unable to clear readable permission to {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                }
            }
            if ((permissions & 2) != 0) {
                if (file.setWritable(false, change == ChangePermission.OWNER)) {
                    logger.log(Level.FINE, "Clear writable permission to {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                } else {
                    logger.log(Level.FINE, "Unable to clear writable permission to {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                }
            }
            if ((permissions & 4) != 0) {
                if (file.setExecutable(false, change == ChangePermission.OWNER)) {
                    logger.log(Level.FINE, "Clear executable permission to {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                } else {
                    logger.log(Level.FINE, "Unable to clear executable permission to {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                }
            }
        }
    }

    public static void checkPermissions(@Nonnull File file, @Nonnull Location location, int permissions) throws WrongPermissionException {
        assert (file.exists());
        if ((permissions & 1) != 0 && !file.canRead()) {
            throw new WrongPermissionException(location, 1);
        }
        if ((permissions & 2) != 0 && !file.canWrite()) {
            throw new WrongPermissionException(location, 2);
        }
        if ((permissions & 4) != 0 && !file.canExecute()) {
            throw new WrongPermissionException(location, 4);
        }
    }

    protected synchronized void addRemover(final @Nonnull File file) {
        assert (this.remover == null);
        if (this.hooks != null) {
            this.remover = new Runnable(){

                @Override
                public void run() {
                    if (file.delete()) {
                        logger.log(Level.FINE, "Remove {0} (''{1}'')", new Object[]{FileOrDirectory.this.location.getDescription(), file.getAbsoluteFile()});
                    } else {
                        logger.log(Level.SEVERE, "Can not delete {0}", FileOrDirectory.this.location.getDescription());
                    }
                }
            };
            assert (this.hooks != null);
            this.hooks.addHook(this.remover);
        }
    }

    protected synchronized void clearRemover() {
        if (this.remover != null) {
            assert (this.hooks != null);
            this.hooks.removeHook(this.remover);
            this.remover = null;
            this.hooks = null;
        }
    }

    @Nonnull
    public static File getFileFromWorkingDirectory(@CheckForNull Directory workingDirectory, @Nonnull String path) {
        File fileWithoutWorkingDir = new File(path);
        if (workingDirectory != null && !fileWithoutWorkingDir.isAbsolute()) {
            return new File(workingDirectory.getFile(), path);
        }
        return fileWithoutWorkingDir;
    }

    public static enum Existence {
        MUST_EXIST,
        NOT_EXIST,
        MAY_EXIST;

    }

    public static enum ChangePermission {
        NOCHANGE,
        OWNER,
        EVERYBODY;

    }

    public static class Permission {
        public static final int READ = 1;
        public static final int WRITE = 2;
        public static final int EXECUTE = 4;
    }
}

