/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.InputJarCodec;
import com.android.sched.util.codec.NotServiceFileException;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.InputJarFile;
import com.android.sched.util.location.Location;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ServiceJarCodec<T>
implements StringCodec<InputJarFile> {
    @Nonnull
    private final InputJarCodec codec = new InputJarCodec();
    @Nonnull
    private final Class<T> type;

    public ServiceJarCodec(@Nonnull Class<T> type) {
        this.type = type;
    }

    @Override
    @Nonnull
    public InputJarFile parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @CheckForNull
    public InputJarFile checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        InputJarFile jar = this.codec.checkString(context, string);
        if (jar == null) {
            jar = this.codec.parseString(context, string);
        }
        try {
            this.checkJarFile(jar);
            return jar;
        }
        catch (Exception e) {
            throw new ParsingException(e);
        }
    }

    @Nonnull
    protected void throwException(@Nonnull Location location) throws Exception {
        throw new NotServiceFileException(location, this.type);
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a service '" + this.type.getCanonicalName() + "' jar file (" + this.codec.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "jar";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull InputJarFile jar) {
        return jar.getPath();
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull InputJarFile jar) throws CheckingException {
        try {
            this.checkJarFile(jar);
        }
        catch (Exception e) {
            throw new CheckingException(e);
        }
    }

    private void checkJarFile(@Nonnull InputJarFile jar) throws Exception {
        try {
            ServiceLoader<T> loader = ServiceLoader.load(this.type, new URLClassLoader(new URL[]{jar.getFile().toURI().toURL()}, ServiceJarCodec.class.getClassLoader()));
            if (!loader.iterator().hasNext()) {
                this.throwException(jar.getLocation());
            }
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }
}

