/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.build;

import com.android.sched.build.JarMerger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class SchedDiscover {
    @Nonnull
    private static final String RESOURCE_NAME = "com.android.sched.discover";
    @Nonnull
    private static final String EOL = System.getProperty("line.separator");
    @Nonnull
    protected final Map<String, Set<SchedData>> map = new HashMap<String, Set<SchedData>>();

    public void add(@Nonnull String name, @Nonnull String element) {
        Set<SchedData> set = this.map.get(name);
        if (set == null) {
            set = new HashSet<SchedData>();
            this.map.put(name, set);
        }
        SchedData data = new SchedData(element);
        set.remove(data);
        set.add(data);
    }

    public void add(@Nonnull String name, @Nonnull String element, @Nonnull String extra) {
        Set<SchedData> set = this.map.get(name);
        if (set == null) {
            set = new HashSet<SchedData>();
            this.map.put(name, set);
        }
        SchedData data = new SchedData(element, extra);
        set.remove(data);
        set.add(data);
    }

    public void remove(@Nonnull String name, @Nonnull String element) {
        Set<SchedData> set = this.map.get(name);
        if (set != null) {
            set.remove(new SchedData(element));
        }
    }

    @Nonnull
    public Set<SchedData> get(@Nonnull String name) {
        Set<SchedData> set = this.map.get(name);
        if (set == null) {
            set = Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public void writeResource(@Nonnull Writer writer) throws IOException {
        this.writeResource(writer, JarMerger.class.getCanonicalName());
    }

    protected void writeResource(@Nonnull Writer writer, @Nonnull String identifier) throws IOException {
        writer.write("#" + EOL);
        writer.write("# Generated by " + identifier + EOL);
        writer.write("# on " + new Date().toString() + EOL);
        writer.write("#" + EOL);
        for (Map.Entry<String, Set<SchedData>> entry : this.map.entrySet()) {
            writer.write("*" + entry.getKey() + EOL);
            for (SchedData element : entry.getValue()) {
                if (element.hasExtra()) {
                    writer.write("-" + element.getExtra() + EOL);
                }
                writer.write("+" + element.getName() + EOL);
            }
        }
    }

    public void readResource(@Nonnull BufferedReader reader) throws IOException {
        String sup = "<error>";
        String extra = null;
        String line = reader.readLine();
        while (line != null) {
            char prefix = line.charAt(0);
            if (prefix == '*') {
                sup = line.substring(1);
            } else if (prefix == '-') {
                extra = line.substring(1);
            } else if (prefix == '+') {
                if (extra != null) {
                    this.add(sup, line.substring(1), extra);
                    extra = null;
                } else {
                    this.add(sup, line.substring(1));
                }
            }
            line = reader.readLine();
        }
    }

    @Nonnull
    public String getResourceName() {
        return RESOURCE_NAME;
    }

    public static class SchedData
    implements Comparable<SchedData> {
        @Nonnull
        private final String name;
        @CheckForNull
        private final String extra;

        public SchedData(@Nonnull String name) {
            this.name = name;
            this.extra = null;
        }

        public SchedData(@Nonnull String name, @Nonnull String extra) {
            this.name = name;
            this.extra = extra;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getExtra() {
            return this.extra;
        }

        boolean hasExtra() {
            return this.extra != null;
        }

        @Override
        public int compareTo(SchedData element) {
            return this.name.compareTo(element.name);
        }

        public boolean equals(Object obj) {
            if (obj instanceof SchedData) {
                return this.name.equals(((SchedData)obj).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

