/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework;

import com.android.jack.uncommons.watchmaker.framework.AbstractEvolutionEngine;
import com.android.jack.uncommons.watchmaker.framework.CandidateFactory;
import com.android.jack.uncommons.watchmaker.framework.EvaluatedCandidate;
import com.android.jack.uncommons.watchmaker.framework.EvolutionaryOperator;
import com.android.jack.uncommons.watchmaker.framework.FitnessEvaluator;
import com.android.jack.uncommons.watchmaker.framework.NullFitnessEvaluator;
import com.android.jack.uncommons.watchmaker.framework.SelectionStrategy;
import com.android.jack.uncommons.watchmaker.framework.interactive.InteractiveSelection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class GenerationalEvolutionEngine<T>
extends AbstractEvolutionEngine<T> {
    private final EvolutionaryOperator<T> evolutionScheme;
    private final FitnessEvaluator<? super T> fitnessEvaluator;
    private final SelectionStrategy<? super T> selectionStrategy;

    public GenerationalEvolutionEngine(CandidateFactory<T> candidateFactory, EvolutionaryOperator<T> evolutionScheme, FitnessEvaluator<? super T> fitnessEvaluator, SelectionStrategy<? super T> selectionStrategy, Random rng) {
        super(candidateFactory, fitnessEvaluator, rng);
        this.evolutionScheme = evolutionScheme;
        this.fitnessEvaluator = fitnessEvaluator;
        this.selectionStrategy = selectionStrategy;
    }

    public GenerationalEvolutionEngine(CandidateFactory<T> candidateFactory, EvolutionaryOperator<T> evolutionScheme, InteractiveSelection<T> selectionStrategy, Random rng) {
        this(candidateFactory, evolutionScheme, new NullFitnessEvaluator(), selectionStrategy, rng);
    }

    @Override
    protected List<EvaluatedCandidate<T>> nextEvolutionStep(List<EvaluatedCandidate<T>> evaluatedPopulation, int eliteCount, Random rng) {
        List<Object> population = new ArrayList(evaluatedPopulation.size());
        ArrayList<T> elite = new ArrayList<T>(eliteCount);
        Iterator<EvaluatedCandidate<T>> iterator = evaluatedPopulation.iterator();
        while (elite.size() < eliteCount) {
            elite.add(iterator.next().getCandidate());
        }
        population.addAll(this.selectionStrategy.select(evaluatedPopulation, this.fitnessEvaluator.isNatural(), evaluatedPopulation.size() - eliteCount, rng));
        population = this.evolutionScheme.apply(population, rng);
        population.addAll(elite);
        return this.evaluatePopulation(population);
    }
}

