/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.exceptions;

import com.android.jack.Options;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JExceptionRuntimeValue;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.request.PrependStatement;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Add JExceptionRuntimeValue expression")
@Name(value="ExceptionRuntimeValueAdder")
@Constraint(need={JCatchBlock.class}, no={JTryStatement.FinallyBlock.class})
@Transform(add={JExceptionRuntimeValue.class, JLocalRef.class, JAsgOperation.NonReusedAsg.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class ExceptionRuntimeValueAdder
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor rca = new Visitor(tr);
        rca.accept(method);
        tr.commit();
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;

        private Visitor(@Nonnull TransformationRequest tr) {
            this.tr = tr;
        }

        @Override
        public boolean visit(@Nonnull JCatchBlock jCatchBlock) {
            SourceInfo sourceInfo = jCatchBlock.getSourceInfo();
            JLocalRef localRef = jCatchBlock.getCatchVar().makeRef(sourceInfo);
            JAsgOperation assign = new JAsgOperation(sourceInfo, localRef, new JExceptionRuntimeValue(sourceInfo, (JClassOrInterface)localRef.getType()));
            this.tr.append(new PrependStatement(jCatchBlock, assign.makeStatement()));
            return super.visit(jCatchBlock);
        }
    }
}

