/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.removeinit;

import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.lookup.JLookupException;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.ast.removeinit.FieldInitMethod;
import com.android.jack.transformations.ast.removeinit.FieldInitMethodCall;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Remove method initializing field values.")
@Name(value="FieldInitMethodRemover")
@Constraint(need={FieldInitMethod.class, OriginalNames.class}, no={FieldInitMethodCall.class})
@Transform(modify={JDefinedClass.class}, remove={FieldInitMethod.class})
@Filter(value={SourceTypeFilter.class})
public class FieldInitMethodRemover
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Nonnull
    static final String VAR_INIT_METHOD_NAME = "$init";

    @Override
    public void run(@Nonnull JDefinedClassOrInterface declaredType) {
        if (declaredType instanceof JDefinedClass) {
            try {
                JMethod varInitMethod = declaredType.getMethod(VAR_INIT_METHOD_NAME, (JType)JPrimitiveType.JPrimitiveTypeEnum.VOID.getType(), new JType[0]);
                TransformationRequest tr = new TransformationRequest(declaredType);
                tr.append(new Remove(varInitMethod));
                tr.commit();
            }
            catch (JLookupException jLookupException) {
                // empty catch block
            }
        }
    }
}

