/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Options;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.RefAsStatement;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Remove JVariableRef and JArrayRef as JExpressionStatement.")
@Name(value="RefAsStatementRemover")
@Constraint(need={ThreeAddressCodeForm.class})
@Transform(remove={RefAsStatement.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class RefAsStatementRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor visitor = new Visitor(tr);
        visitor.accept(method);
        tr.commit();
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;

        public Visitor(@Nonnull TransformationRequest tr) {
            this.tr = tr;
        }

        @Override
        public boolean visit(@Nonnull JExpressionStatement expressionStatement) {
            JExpression expr = expressionStatement.getExpr();
            if (expr instanceof JVariableRef) {
                this.tr.append(new Remove(expressionStatement));
                return false;
            }
            return super.visit(expressionStatement);
        }
    }
}

