/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Options;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JDoStatement;
import com.android.jack.ir.ast.JForStatement;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.JWhileStatement;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.SanityChecks;
import com.android.jack.transformations.ast.NoImplicitBlock;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Check that all implicit blocks are created.")
@Name(value="ImplicitBlocksChecker")
@Constraint(need={NoImplicitBlock.class})
@Support(value={SanityChecks.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
public class ImplicitBlocksChecker
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        BlockStatisticsVisitor statistics = new BlockStatisticsVisitor();
        statistics.accept(method);
    }

    private static class BlockStatisticsVisitor
    extends JVisitor {
        private BlockStatisticsVisitor() {
        }

        @Override
        public boolean visit(@Nonnull JIfStatement ifStmt) {
            JStatement thenStmt = ifStmt.getThenStmt();
            JStatement elseStmt = ifStmt.getElseStmt();
            if (thenStmt != null && !(thenStmt instanceof JBlock) || elseStmt != null && !(elseStmt instanceof JBlock)) {
                throw new AssertionError((Object)"If statement with stand-alone statement.");
            }
            return super.visit(ifStmt);
        }

        @Override
        public boolean visit(@Nonnull JLabeledStatement labeledStmt) {
            if (!(labeledStmt.getBody() instanceof JBlock)) {
                throw new AssertionError((Object)"Labeled statement with stand-alone statement.");
            }
            return super.visit(labeledStmt);
        }

        @Override
        public boolean visit(@Nonnull JForStatement forStmt) {
            JBlock parentBlock;
            if (!(forStmt.getBody() instanceof JBlock)) {
                throw new AssertionError((Object)"For statement with stand-alone statement.");
            }
            JNode parent = forStmt.getParent();
            if (parent instanceof JBlock && (parentBlock = (JBlock)parent).getStatements().size() != 1) {
                throw new AssertionError((Object)"Implicit block surrounded for statement does not exist.");
            }
            return super.visit(forStmt);
        }

        @Override
        public boolean visit(@Nonnull JWhileStatement whileStmt) {
            if (!(whileStmt.getBody() instanceof JBlock)) {
                throw new AssertionError((Object)"For statement with stand-alone statement.");
            }
            return super.visit(whileStmt);
        }

        @Override
        public void endVisit(@Nonnull JDoStatement doWhileStatement) {
            if (!(doWhileStatement.getBody() instanceof JBlock)) {
                throw new AssertionError((Object)"Do while statement with stand-alone statement.");
            }
            super.endVisit(doWhileStatement);
        }
    }
}

