/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.assertion;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JAssertStatement;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JPrefixNotOperation;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JThrowStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JLookupException;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.InitializationExpression;
import com.android.jack.transformations.assertion.DynamicAssertionFeature;
import com.android.jack.transformations.ast.BooleanTestOutsideIf;
import com.android.jack.transformations.ast.NewInstanceRemoved;
import com.android.jack.transformations.request.AppendField;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.NamingTools;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;

@Description(value="Transforms assert into a throw if assertions are enabled")
@Name(value="DynamicAssertionTransformer")
@Synchronized
@Constraint(need={JAssertStatement.class})
@Transform(add={BooleanTestOutsideIf.class, JIfStatement.class, JThrowStatement.class, JPrefixNotOperation.class, JMethodCall.class, JBlock.class, JFieldRef.class, JField.class, JClassLiteral.class, JNewInstance.class, JAsgOperation.NonReusedAsg.class, InitializationExpression.class, JExpressionStatement.class}, remove={JAssertStatement.class, ThreeAddressCodeForm.class, NewInstanceRemoved.class})
@Support(value={DynamicAssertionFeature.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
@ExclusiveAccess(value=JDefinedClassOrInterface.class)
public class DynamicAssertionTransformer
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final JClass jlo = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_OBJECT);
    @Nonnull
    private static final String ASSERTION_FIELD_NAME = NamingTools.getNonSourceConflictingName("assertionsDisabled");

    @Override
    public synchronized void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor(method.getEnclosingType());
        visitor.accept(method);
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final JDefinedClassOrInterface currentType;

        public Visitor(JDefinedClassOrInterface type) {
            this.currentType = type;
        }

        @Nonnull
        private JFieldId getOrCreateAssertionstatusField(@Nonnull TransformationRequest request) {
            try {
                JFieldId id = this.currentType.getFieldId(ASSERTION_FIELD_NAME, JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType(), FieldKind.STATIC);
                JField field = id.getField();
                if (field != null && field.getEnclosingType().isSameType(this.currentType)) {
                    return id;
                }
            }
            catch (JLookupException jLookupException) {
                // empty catch block
            }
            return this.addAssertionStatusToType(this.currentType, request);
        }

        @Nonnull
        private JFieldId addAssertionStatusToType(@Nonnull JDefinedClassOrInterface type, @Nonnull TransformationRequest request) {
            SourceInfo sourceInfo = SourceInfo.UNKNOWN;
            int modifier = 4120;
            JField assertionStatus = new JField(SourceInfo.UNKNOWN, ASSERTION_FIELD_NAME, this.currentType, JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType(), modifier);
            JFieldId assertionStatusId = assertionStatus.getId();
            request.append(new AppendField(this.currentType, assertionStatus));
            JClass javaLangClass = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_CLASS);
            JClassLiteral thisClass = new JClassLiteral(sourceInfo, type, javaLangClass);
            JFieldRef lhs = new JFieldRef(sourceInfo, null, assertionStatusId, type);
            JPrefixNotOperation rhs = new JPrefixNotOperation(sourceInfo, new JMethodCall(sourceInfo, thisClass, javaLangClass, javaLangClass.getOrCreateMethodIdWide("desiredAssertionStatus", Collections.emptyList(), MethodKind.INSTANCE_VIRTUAL), JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType(), true));
            JAsgOperation asg = new JAsgOperation(SourceInfo.UNKNOWN, lhs, rhs);
            assertionStatus.addMarker(new InitializationExpression(asg.makeStatement()));
            return assertionStatusId;
        }

        @Override
        public void endVisit(@Nonnull JAssertStatement assertSt) {
            TransformationRequest request = new TransformationRequest(assertSt);
            JFieldId assertionStatus = this.getOrCreateAssertionstatusField(request);
            JPrefixNotOperation assertionEnabledCondition = new JPrefixNotOperation(assertSt.getSourceInfo(), new JFieldRef(assertSt.getSourceInfo(), null, assertionStatus, this.currentType));
            JExpression testExpression = assertSt.getTestExpr();
            JPrefixNotOperation notTestCondition = new JPrefixNotOperation(testExpression.getSourceInfo(), testExpression);
            ArrayList<JClass> ctorDescriptor = new ArrayList<JClass>();
            JExpression arg = assertSt.getArg();
            if (arg != null) {
                ctorDescriptor.add(DynamicAssertionTransformer.this.jlo);
            }
            JClass assertionError = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_ASSERTION_ERROR);
            JNewInstance newAssertionError = new JNewInstance(assertSt.getSourceInfo(), assertionError, assertionError.getOrCreateMethodIdWide("<init>", ctorDescriptor, MethodKind.INSTANCE_NON_VIRTUAL));
            if (arg != null) {
                newAssertionError.addArg(arg);
            }
            JThrowStatement throwAssertionError = new JThrowStatement(assertSt.getSourceInfo(), newAssertionError);
            JBlock blockThrow = new JBlock(assertSt.getSourceInfo());
            blockThrow.addStmt(throwAssertionError);
            JIfStatement ifNotTest = new JIfStatement(assertSt.getSourceInfo(), notTestCondition, blockThrow, null);
            JBlock thenAssertionEnabled = new JBlock(assertSt.getSourceInfo());
            thenAssertionEnabled.addStmt(ifNotTest);
            JIfStatement ifAssertionEnabled = new JIfStatement(assertSt.getSourceInfo(), assertionEnabledCondition, thenAssertionEnabled, null);
            request.append(new Replace(assertSt, ifAssertionEnabled));
            request.commit();
        }
    }
}

