/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.annotation;

import com.android.jack.ir.ast.Annotable;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JArrayLiteral;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.annotation.ContainerAnnotationMarker;
import com.android.jack.transformations.request.AddAnnotation;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;

@Transform(add={JAnnotation.class, JNameValuePair.class, JArrayLiteral.class})
@ExclusiveAccess(value=JSession.class)
public class ContainerAnnotationAdder {
    protected void addContainerAnnotationIfNeeded(@Nonnull TransformationRequest tr, @Nonnull Annotable annotable) {
        for (JAnnotationType annotationType : annotable.getAnnotationTypes()) {
            Collection<JAnnotation> annotationsOfSameType = annotable.getAnnotations(annotationType);
            if (annotationsOfSameType.size() <= 1) continue;
            for (JAnnotation annotation : annotationsOfSameType) {
                tr.append(new Remove(annotation));
            }
            ContainerAnnotationMarker cam = annotationsOfSameType.iterator().next().getMarker(ContainerAnnotationMarker.class);
            assert (cam != null);
            JAnnotation containerAnnotation = new JAnnotation(SourceInfo.UNKNOWN, cam.getRetentionPolicy(), cam.getContainerAnnotationType());
            JMethodIdWide methodId = cam.getContainerAnnotationType().getOrCreateMethodIdWide("value", Collections.emptyList(), MethodKind.INSTANCE_VIRTUAL);
            containerAnnotation.add(new JNameValuePair(SourceInfo.UNKNOWN, methodId, new JArrayLiteral(SourceInfo.UNKNOWN, new ArrayList<JLiteral>(annotationsOfSameType))));
            tr.append(new AddAnnotation(containerAnnotation, annotable));
        }
    }

    @Description(value="Add container annotations on a method and its parameters when they are needed")
    @Constraint(need={ContainerAnnotationMarker.class})
    @Transform(remove={JAnnotation.RepeatedAnnotationOnMethod.class})
    @Use(value={ContainerAnnotationAdder.class})
    @ExclusiveAccess(value=JSession.class)
    @Filter(value={TypeWithoutPrebuiltFilter.class})
    public static class MethodContainerAnnotationAdder
    extends ContainerAnnotationAdder
    implements RunnableSchedulable<JMethod> {
        @Override
        public void run(@Nonnull JMethod jMethod) {
            TransformationRequest tr = new TransformationRequest(jMethod);
            this.addContainerAnnotationIfNeeded(tr, jMethod);
            for (JParameter parameter : jMethod.getParams()) {
                this.addContainerAnnotationIfNeeded(tr, parameter);
            }
            tr.commit();
        }
    }

    @Description(value="Add container annotations on a field when they are needed")
    @Constraint(need={ContainerAnnotationMarker.class})
    @Transform(remove={JAnnotation.RepeatedAnnotationOnField.class})
    @Use(value={ContainerAnnotationAdder.class})
    @ExclusiveAccess(value=JSession.class)
    @Filter(value={TypeWithoutPrebuiltFilter.class})
    public static class FieldContainerAnnotationAdder
    extends ContainerAnnotationAdder
    implements RunnableSchedulable<JField> {
        @Override
        public void run(@Nonnull JField type) {
            TransformationRequest tr = new TransformationRequest(type);
            this.addContainerAnnotationIfNeeded(tr, type);
            tr.commit();
        }
    }

    @Description(value="Add container annotations on a type when they are needed")
    @Constraint(need={ContainerAnnotationMarker.class})
    @Transform(remove={JAnnotation.RepeatedAnnotationOnType.class})
    @Use(value={ContainerAnnotationAdder.class})
    @ExclusiveAccess(value=JSession.class)
    @Filter(value={TypeWithoutPrebuiltFilter.class})
    public static class TypeContainerAnnotationAdder
    extends ContainerAnnotationAdder
    implements RunnableSchedulable<JDefinedClassOrInterface> {
        @Override
        public void run(@Nonnull JDefinedClassOrInterface type) {
            TransformationRequest tr = new TransformationRequest(type);
            this.addContainerAnnotationIfNeeded(tr, type);
            tr.commit();
        }
    }
}

