/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.spec;

import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.shrob.proguard.GrammarActions;
import com.android.jack.shrob.spec.AnnotationSpecification;
import com.android.jack.shrob.spec.ModifierSpecification;
import com.android.jack.shrob.spec.NameSpecification;
import com.android.jack.shrob.spec.Specification;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class MethodSpecification
implements Specification<JMethod> {
    @CheckForNull
    private final AnnotationSpecification annotationType;
    @CheckForNull
    private final ModifierSpecification modifier;
    @Nonnull
    private final NameSpecification sigPattern;

    public MethodSpecification(@Nonnull NameSpecification sigPattern, @CheckForNull ModifierSpecification modifier, @CheckForNull AnnotationSpecification annotationType) {
        this.sigPattern = sigPattern;
        this.modifier = modifier;
        this.annotationType = annotationType;
    }

    @Override
    public boolean matches(@Nonnull JMethod t) {
        if (this.modifier != null && !this.modifier.matches(t)) {
            return false;
        }
        if (this.annotationType != null && !this.annotationType.matches(t.getAnnotations())) {
            return false;
        }
        String signature = GrammarActions.getSignatureFormatter().getName(t);
        if (t instanceof JConstructor) {
            String methodName = signature.replace("<init>", t.getEnclosingType().getName());
            if (this.sigPattern.matches(methodName)) {
                return true;
            }
            methodName = signature.replace("<init>", GrammarActions.getSourceFormatter().getName(t.getEnclosingType()));
            if (this.sigPattern.matches(methodName)) {
                return true;
            }
        }
        return this.sigPattern.matches(signature);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder("method: ");
        if (this.annotationType != null) {
            sb.append(this.annotationType);
            sb.append(' ');
        }
        if (this.modifier != null) {
            sb.append(this.modifier);
            sb.append(' ');
        }
        sb.append(this.sigPattern);
        sb.append(';');
        return sb.toString();
    }
}

