/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.seed;

import com.android.jack.Options;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JSession;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.shrob.seed.SeedMarker;
import com.android.jack.shrob.shrink.NodeFinder;
import com.android.jack.shrob.spec.ClassSpecification;
import com.android.jack.shrob.spec.FieldSpecification;
import com.android.jack.shrob.spec.Flags;
import com.android.jack.shrob.spec.KeepModifier;
import com.android.jack.shrob.spec.MethodSpecification;
import com.android.jack.shrob.spec.Specification;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import java.util.List;
import javax.annotation.Nonnull;

@HasKeyId
@Description(value="Visitor that find seeds")
@Constraint(need={OriginalNames.class})
@Transform(add={SeedMarker.class})
@Access(value=JSession.class)
public class SeedFinder
implements RunnableSchedulable<JDefinedClassOrInterface> {
    public static final BooleanPropertyId SEARCH_SEEDS_IN_HIERARCHY = BooleanPropertyId.create("jack.shrob.seed.searchinhierarchy", "Search for shrob seeds in hierarchy").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    @Nonnull
    private final Flags flags = ThreadConfig.get(Options.FLAGS);
    @Nonnull
    protected final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final boolean searchInHierarchy = ThreadConfig.get(SEARCH_SEEDS_IN_HIERARCHY);

    private void markIfNecessary(@Nonnull JNode node, @Nonnull KeepModifier modifier) {
        SeedMarker marker = node.addMarkerIfAbsent(new SeedMarker(modifier));
        if (marker != null) {
            marker.mergeModifier(modifier);
        }
    }

    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        JDefinedClass definedSuperclass;
        JClass superclass;
        List<MethodSpecification> methodSpecs;
        List<FieldSpecification> fieldSpecs;
        KeepModifier keepModifier;
        for (ClassSpecification classSpec : this.flags.getKeepClassSpecs()) {
            if (!classSpec.matches(type)) continue;
            keepModifier = classSpec.getKeepModifier();
            fieldSpecs = classSpec.getFieldSpecs();
            methodSpecs = classSpec.getMethodSpecs();
            this.markIfNecessary(type, keepModifier);
            this.matchSpecifications(type.getFields(), fieldSpecs, keepModifier);
            this.matchSpecifications(type.getMethods(), methodSpecs, keepModifier);
            if (!this.searchInHierarchy) continue;
            superclass = type.getSuperClass();
            while (superclass instanceof JDefinedClass) {
                definedSuperclass = (JDefinedClass)superclass;
                this.matchSpecifications(definedSuperclass.getFields(), fieldSpecs, keepModifier);
                this.matchSpecifications(definedSuperclass.getMethods(), methodSpecs, keepModifier);
                superclass = definedSuperclass.getSuperClass();
            }
        }
        for (ClassSpecification classSpec : this.flags.getKeepClassMembersSpecs()) {
            if (!classSpec.matches(type)) continue;
            keepModifier = classSpec.getKeepModifier();
            fieldSpecs = classSpec.getFieldSpecs();
            methodSpecs = classSpec.getMethodSpecs();
            this.matchSpecifications(type.getFields(), fieldSpecs, keepModifier);
            this.matchSpecifications(type.getMethods(), methodSpecs, keepModifier);
            if (!this.searchInHierarchy) continue;
            superclass = type.getSuperClass();
            while (superclass instanceof JDefinedClass) {
                definedSuperclass = (JDefinedClass)superclass;
                this.matchSpecifications(definedSuperclass.getFields(), fieldSpecs, keepModifier);
                this.matchSpecifications(definedSuperclass.getMethods(), methodSpecs, keepModifier);
                superclass = definedSuperclass.getSuperClass();
            }
        }
        for (ClassSpecification classSpec : this.flags.getKeepClassesWithMembersSpecs()) {
            if (!classSpec.matches(type)) continue;
            NodeFinder<JField> fieldFinder = new NodeFinder<JField>(type.getFields());
            fieldFinder.find(classSpec.getFieldSpecs());
            NodeFinder<JMethod> methodFinder = new NodeFinder<JMethod>(type.getMethods());
            methodFinder.find(classSpec.getMethodSpecs());
            if (!fieldFinder.allSpecificationsMatched() || !methodFinder.allSpecificationsMatched()) continue;
            KeepModifier keepModifier2 = classSpec.getKeepModifier();
            this.markIfNecessary(type, keepModifier2);
            List<FieldSpecification> fieldSpecs2 = classSpec.getFieldSpecs();
            List<MethodSpecification> methodSpecs2 = classSpec.getMethodSpecs();
            this.matchSpecifications(type.getFields(), fieldSpecs2, keepModifier2);
            this.matchSpecifications(type.getMethods(), methodSpecs2, keepModifier2);
        }
    }

    private <T extends JNode> void matchSpecifications(@Nonnull List<T> nodes, @Nonnull List<? extends Specification<T>> specs, KeepModifier keepModifier) {
        block0: for (JNode node : nodes) {
            for (Specification<JNode> specification : specs) {
                if (!specification.matches(node)) continue;
                this.markIfNecessary(node, keepModifier);
                continue block0;
            }
        }
    }
}

