/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.annotation;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfoFactory;
import com.android.jack.shrob.obfuscation.annotation.RemoveLineNumber;
import com.android.sched.item.Description;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import javax.annotation.Nonnull;

@Description(value="Removes line numbers")
@Support(value={RemoveLineNumber.class})
public class LineNumberRemover
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        Visitor visitor = new Visitor(Jack.getSession().getSourceInfoFactory());
        visitor.accept(type);
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final SourceInfoFactory sourceInfoFactory;

        public Visitor(@Nonnull SourceInfoFactory sourceInfoFactory) {
            this.sourceInfoFactory = sourceInfoFactory;
        }

        @Override
        public boolean visit(@Nonnull JNode node) {
            SourceInfo info = node.getSourceInfo();
            if (info != SourceInfo.UNKNOWN) {
                node.setSourceInfo(info.getFileSourceInfo());
            }
            return false;
        }
    }
}

