/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.annotation;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JField;
import com.android.jack.scheduling.feature.SourceVersion8;
import com.android.jack.shrob.obfuscation.annotation.AnnotationRemover;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Optional;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.ToSupport;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@Description(value="RunnableSchedulable that removes annotations from fields.")
@Constraint(need={JAnnotation.class})
@Transform(modify={JAnnotation.class})
@Optional(value={@ToSupport(feature={SourceVersion8.class}, add={@Constraint(need={JAnnotation.RepeatedAnnotation.class})})})
public class FieldAnnotationRemover
extends AnnotationRemover
implements RunnableSchedulable<JField> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();

    public FieldAnnotationRemover() {
        super(ThreadConfig.get(EMIT_SOURCE_RETENTION_ANNOTATION), ThreadConfig.get(EMIT_CLASS_RETENTION_ANNOTATION), ThreadConfig.get(EMIT_RUNTIME_RETENTION_ANNOTATION), true);
    }

    @Override
    public void run(@Nonnull JField field) {
        TransformationRequest request = new TransformationRequest(field);
        for (JAnnotation annotation : field.getAnnotations()) {
            if (this.mustBeKept(annotation)) continue;
            request.append(new Remove(annotation));
            logger.log(Level.INFO, "Removed annotation {0} from field {1}.{2}", new Object[]{Jack.getUserFriendlyFormatter().getName(annotation.getType()), Jack.getUserFriendlyFormatter().getName(field.getEnclosingType()), field.getName()});
        }
        request.commit();
    }
}

