/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.JackIOException;
import com.android.jack.ir.ast.HasName;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.shrob.obfuscation.Renamer;
import com.android.jack.shrob.obfuscation.nameprovider.DictionaryNameProvider;
import com.android.jack.shrob.obfuscation.nameprovider.MappingNameProvider;
import com.android.jack.shrob.obfuscation.nameprovider.NameProvider;
import com.android.jack.shrob.obfuscation.nameprovider.UniqueNameProvider;
import com.android.sched.marker.MarkerManager;
import com.android.sched.util.codec.DefaultFactorySelector;
import com.android.sched.util.config.DefaultFactory;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.PropertyId;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@HasKeyId
public class NameProviderFactory {
    @Nonnull
    public static final PropertyId<DefaultFactory<NameProvider>> NAMEPROVIDER = PropertyId.create("jack.obfuscation.nameprovider", "Define which nameprovider to use", new DefaultFactorySelector<NameProvider>(NameProvider.class)).addDefaultValue((NameProvider)((Object)"lower-case")).addCategory(DumpInLibrary.class);
    @CheckForNull
    private final File obfuscationDictionary;
    @CheckForNull
    private final File classObfuscationDictionary;
    @CheckForNull
    private final File packageObfuscationDictionary;
    @CheckForNull
    private NameProvider globalFieldNameProvider;
    @CheckForNull
    private NameProvider globalMethodNameProvider;
    @Nonnull
    private final DefaultFactory<NameProvider> defaultNameProviderFactory;

    public NameProviderFactory(@CheckForNull File obfuscationDictionary, @CheckForNull File classObfuscationDictionary, @CheckForNull File packageObfuscationDictionary) {
        this.obfuscationDictionary = obfuscationDictionary;
        this.classObfuscationDictionary = classObfuscationDictionary;
        this.packageObfuscationDictionary = packageObfuscationDictionary;
        this.defaultNameProviderFactory = ThreadConfig.get(NAMEPROVIDER);
    }

    @Nonnull
    private NameProvider getNameProvider(@CheckForNull File dictionary) throws JackIOException {
        NameProvider defaultNameProvider = this.defaultNameProviderFactory.create();
        if (dictionary != null) {
            return new DictionaryNameProvider(dictionary, defaultNameProvider);
        }
        return defaultNameProvider;
    }

    private void fillExistingName(@Nonnull Collection<? extends HasName> namedElements, @Nonnull Collection<String> existingNames) {
        for (HasName hasName : namedElements) {
            if (Renamer.mustBeRenamed((MarkerManager)((Object)hasName))) continue;
            existingNames.add(hasName.getName());
        }
    }

    @Nonnull
    public NameProvider getPackageNameProvider(@Nonnull Collection<JPackage> packages) throws JackIOException {
        HashSet<String> existingNames = new HashSet<String>();
        this.fillExistingName(packages, existingNames);
        return new UniqueNameProvider(this.getNameProvider(this.packageObfuscationDictionary), existingNames);
    }

    @Nonnull
    public NameProvider getClassNameProvider(@Nonnull Collection<? extends JClassOrInterface> types) {
        HashSet<String> existingNames = new HashSet<String>();
        this.fillExistingName(types, existingNames);
        return new UniqueNameProvider(this.getNameProvider(this.classObfuscationDictionary), existingNames);
    }

    @Nonnull
    public NameProvider getFieldNameProvider() throws JackIOException {
        NameProvider provider = this.globalFieldNameProvider != null ? this.globalFieldNameProvider : this.getNameProvider(this.obfuscationDictionary);
        return provider;
    }

    @Nonnull
    public NameProvider getMethodNameProvider() throws JackIOException {
        NameProvider provider = this.globalMethodNameProvider != null ? this.globalMethodNameProvider : this.getNameProvider(this.obfuscationDictionary);
        return provider;
    }

    public void createGlobalFieldNameProvider(@Nonnull Map<String, String> existingNames, @Nonnull Collection<JFieldId> fieldIds) throws JackIOException {
        for (JFieldId fid : fieldIds) {
            if (Renamer.mustBeRenamed(fid)) continue;
            existingNames.put(Renamer.getKey(fid), fid.getName());
        }
        this.globalFieldNameProvider = new MappingNameProvider(this.getNameProvider(this.obfuscationDictionary), existingNames);
    }

    public void createGlobalMethodNameProvider(@Nonnull Map<String, String> existingNames, @Nonnull Collection<JMethodIdWide> methodIds) throws JackIOException {
        for (JMethodIdWide mid : methodIds) {
            if (Renamer.mustBeRenamed(mid)) continue;
            existingNames.put(Renamer.getKey(mid), mid.getName());
        }
        this.globalMethodNameProvider = new MappingNameProvider(this.getNameProvider(this.obfuscationDictionary), existingNames);
    }
}

