/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.shrob.obfuscation.NewMethodSignatureMarker;
import com.android.jack.shrob.obfuscation.OneTimeHierarchyVisitor;
import com.android.jack.shrob.obfuscation.Renamer;
import javax.annotation.Nonnull;

public class MethodInHierarchyFinder
extends OneTimeHierarchyVisitor {
    @Nonnull
    private final String methodKey;
    private boolean hasFoundMethodId = false;

    private MethodInHierarchyFinder(@Nonnull String methodKey) {
        this.methodKey = methodKey;
    }

    public void startVisit(@Nonnull JDefinedClassOrInterface type) {
        for (JMethod sameEnclosingTypeMethod : type.getMethods()) {
            JMethodIdWide id = sameEnclosingTypeMethod.getMethodId().getMethodIdWide();
            if (id.canBeVirtual() || Renamer.mustBeRenamed(id) || !Renamer.getKey(id).equals(this.methodKey)) continue;
            this.hasFoundMethodId = true;
            return;
        }
        this.visit(type);
        this.visitSuperTypes(type);
        this.visitSubTypes(type);
    }

    @Override
    public boolean doAction(@Nonnull JDefinedClassOrInterface type) {
        NewMethodSignatureMarker marker = type.getMarker(NewMethodSignatureMarker.class);
        if (marker != null && marker.getNewNames().contains(this.methodKey)) {
            this.hasFoundMethodId = true;
            return false;
        }
        for (JMethod sameEnclosingTypeMethod : type.getMethods()) {
            JMethodIdWide id = sameEnclosingTypeMethod.getMethodId().getMethodIdWide();
            if (!id.canBeVirtual() || Renamer.mustBeRenamed(id) || !Renamer.getKey(id).equals(this.methodKey)) continue;
            this.hasFoundMethodId = true;
            return false;
        }
        return true;
    }

    public static boolean containsMethodKey(@Nonnull String methodKey, @Nonnull JMethodIdWide methodId) {
        MethodInHierarchyFinder visitor = new MethodInHierarchyFinder(methodKey);
        for (JMethod otherMethod : methodId.getMethods()) {
            visitor.startVisit(otherMethod.getEnclosingType());
        }
        return visitor.hasFoundMethodId;
    }
}

