/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.reporting;

import com.android.jack.google.common.base.Strings;
import com.android.jack.reporting.CommonReporter;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.Reporter;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.location.ColumnAndLineLocation;
import com.android.sched.util.location.FileOrDirLocation;
import com.android.sched.util.location.Location;
import java.io.File;
import java.io.PrintWriter;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@ImplementationName(iface=Reporter.class, name="sdk")
public class SdkReporter
extends CommonReporter {
    private static final int SDK_UNKNOWN_VALUE = -1;

    @Override
    protected void printFilteredProblem(@Nonnull Reportable.ProblemLevel problemLevel, @Nonnull String message, @CheckForNull Location location) {
        String escapedMessage = SdkReporter.convertString(message);
        StringBuffer messageBuffer = new StringBuffer("AGPBI: {");
        messageBuffer.append("\"kind\":\"").append(this.convertLevelName(problemLevel)).append("\",");
        messageBuffer.append("\"text\":\"").append(escapedMessage).append("\",");
        messageBuffer.append("\"sources\":[{");
        if (location != null) {
            String filePath = null;
            ColumnAndLineLocation call = null;
            Location currentLocation = location;
            if (currentLocation instanceof ColumnAndLineLocation) {
                call = (ColumnAndLineLocation)currentLocation;
                currentLocation = call.getParentLocation();
            }
            if (currentLocation instanceof FileOrDirLocation) {
                filePath = ((FileOrDirLocation)currentLocation).getPath();
            }
            if (filePath != null) {
                String fileName = new File(filePath).getAbsolutePath();
                String escapedFileName = SdkReporter.convertString(fileName);
                messageBuffer.append("\"file\":\"").append(escapedFileName).append("\",");
                messageBuffer.append("\"position\":{");
                if (call != null) {
                    int sdkStartLine = -1;
                    int sdkStartColumn = -1;
                    int sdkEndLine = -1;
                    int sdkEndColumn = -1;
                    if (call.hasStartLine()) {
                        sdkStartLine = call.getStartLine() - 1;
                        assert (sdkStartLine >= 0);
                    }
                    if (call.hasEndLine()) {
                        sdkEndLine = call.getEndLine() - 1;
                        assert (sdkEndLine >= 0);
                    } else {
                        sdkEndLine = sdkStartLine;
                    }
                    if (call.hasStartColumn()) {
                        sdkStartColumn = call.getStartColumn() - 1;
                        assert (sdkStartColumn >= 0);
                    }
                    if (call.hasEndColumn()) {
                        sdkEndColumn = call.getEndColumn() - 1;
                        assert (sdkEndColumn >= 0);
                    } else {
                        sdkEndColumn = sdkStartColumn;
                    }
                    messageBuffer.append("\"startLine\":").append(sdkStartLine).append(',');
                    messageBuffer.append("\"startColumn\":").append(sdkStartColumn).append(',');
                    messageBuffer.append("\"startOffset\":").append(-1).append(',');
                    messageBuffer.append("\"endLine\":").append(sdkEndLine).append(',');
                    messageBuffer.append("\"endColumn\":").append(sdkEndColumn).append(',');
                    messageBuffer.append("\"endOffset\":").append(-1);
                }
                messageBuffer.append('}');
            }
        }
        messageBuffer.append("}]}");
        PrintWriter writer = (PrintWriter)this.writerByLevel.get((Object)problemLevel);
        if (writer == null) {
            writer = this.writerByDefault;
        }
        writer.println(messageBuffer.toString());
    }

    private String convertLevelName(@Nonnull Reportable.ProblemLevel problemLevel) {
        switch (problemLevel) {
            case ERROR: {
                return "ERROR";
            }
            case WARNING: {
                return "WARNING";
            }
            case INFO: {
                return "INFO";
            }
        }
        throw new AssertionError((Object)("Unkown problem level: '" + problemLevel.name() + "'"));
    }

    @Nonnull
    private static String convertString(@Nonnull String s) {
        StringBuffer buffer = new StringBuffer();
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    buffer.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block10;
                }
                case '/': {
                    buffer.append("\\/");
                    continue block10;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block10;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block10;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block10;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block10;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        buffer.append("\\u");
                        String cAsHex = Integer.toHexString(c);
                        buffer.append(Strings.repeat("0", 4 - cAsHex.length()));
                        buffer.append(cAsHex.toUpperCase());
                        continue block10;
                    }
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }
}

