/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.reporting;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.HasSourceInfo;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.Reporter;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.WriterFile;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.log.ThreadWithTracer;
import com.android.sched.util.stream.CustomPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

abstract class CommonReporter
implements Reporter {
    @Nonnull
    private static final Logger logger = Logger.getLogger(CommonReporter.class.getName());
    @Nonnull
    private final Options.VerbosityLevel verbosityLevel = ThreadConfig.get(Options.VERBOSITY_LEVEL);
    @Nonnull
    private final LinkedBlockingDeque<Problem> toProcess = new LinkedBlockingDeque();
    @Nonnull
    protected final CustomPrintWriter writerByDefault = ThreadConfig.get(REPORTER_WRITER).getPrintWriter();
    @Nonnull
    protected final Map<Reportable.ProblemLevel, CustomPrintWriter> writerByLevel = new EnumMap<Reportable.ProblemLevel, CustomPrintWriter>(Reportable.ProblemLevel.class);
    @Nonnull
    protected final PrintWriter reporterStream = ThreadConfig.get(REPORTER_WRITER).getPrintWriter();

    protected CommonReporter() {
        for (Map.Entry<Reportable.ProblemLevel, WriterFile> entry : ThreadConfig.get(Reporter.REPORTER_WRITER_BY_LEVEL).entrySet()) {
            this.writerByLevel.put(entry.getKey(), entry.getValue().getPrintWriter());
        }
        final ThreadWithTracer reporterThread = new ThreadWithTracer(new RunReporter(), "Jack reporter");
        ((Thread)reporterThread).start();
        Jack.getSession().getHooks().addHook(new Runnable(){

            @Override
            public void run() {
                CommonReporter.this.toProcess.add(ReportingDone.INSTANCE);
                try {
                    reporterThread.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    @Override
    public void report(@Nonnull Reporter.Severity severity, @Nonnull Reportable reportable) {
        if (severity == Reporter.Severity.FATAL || reportable.getDefaultProblemLevel().isVisibleWith(this.verbosityLevel)) {
            this.toProcess.add(new ProblemDescription(severity, reportable));
        }
    }

    private void handleProblem(@Nonnull Reporter.Severity severity, @Nonnull Reportable reportable) {
        Reportable.ProblemLevel problemLevel = severity == Reporter.Severity.FATAL ? Reportable.ProblemLevel.ERROR : reportable.getDefaultProblemLevel();
        if (reportable instanceof HasLocation) {
            assert (!(reportable instanceof HasSourceInfo));
            this.printFilteredProblem(problemLevel, reportable.getMessage(), ((HasLocation)((Object)reportable)).getLocation());
        } else if (reportable instanceof HasSourceInfo) {
            this.printFilteredProblem(problemLevel, reportable.getMessage(), ((HasSourceInfo)((Object)reportable)).getSourceInfo().getLocation());
        } else {
            this.printFilteredProblem(problemLevel, reportable.getMessage());
        }
    }

    private void printFilteredProblem(@Nonnull Reportable.ProblemLevel problemLevel, @Nonnull String message) {
        this.printFilteredProblem(problemLevel, message, null);
    }

    protected abstract void printFilteredProblem(@Nonnull Reportable.ProblemLevel var1, @Nonnull String var2, @CheckForNull Location var3);

    private void close(@Nonnull WriterFile file) {
        CustomPrintWriter writer = file.getPrintWriter();
        try {
            writer.throwPendingException();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Pending exception writing " + file.getLocation().getDescription(), e);
        }
        try {
            writer.close();
            writer.throwPendingException();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to close " + file.getLocation().getDescription(), e);
        }
    }

    private static class ReportingDone
    implements Problem {
        @Nonnull
        public static final ReportingDone INSTANCE = new ReportingDone();

        private ReportingDone() {
        }

        @Override
        public Reporter.Severity getSeverity() {
            throw new AssertionError();
        }

        @Override
        public Reportable getReportable() {
            throw new AssertionError();
        }
    }

    private static class ProblemDescription
    implements Problem {
        @Nonnull
        private final Reporter.Severity severity;
        @Nonnull
        private final Reportable reportable;

        ProblemDescription(@Nonnull Reporter.Severity severity, @Nonnull Reportable reportable) {
            this.severity = severity;
            this.reportable = reportable;
        }

        @Override
        @Nonnull
        public Reporter.Severity getSeverity() {
            return this.severity;
        }

        @Override
        @Nonnull
        public Reportable getReportable() {
            return this.reportable;
        }
    }

    private static interface Problem {
        @Nonnull
        public Reporter.Severity getSeverity();

        @Nonnull
        public Reportable getReportable();
    }

    class RunReporter
    implements Runnable {
        RunReporter() {
        }

        @Override
        public void run() {
            try {
                Problem current;
                while ((current = (Problem)CommonReporter.this.toProcess.takeFirst()) != ReportingDone.INSTANCE) {
                    CommonReporter.this.handleProblem(current.getSeverity(), current.getReportable());
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.FINE, "Reporter thread '" + Thread.currentThread().getName() + "' was interrupted");
                Thread.currentThread().interrupt();
            }
            CommonReporter.this.close(ThreadConfig.get(Reporter.REPORTER_WRITER));
            for (Map.Entry<Reportable.ProblemLevel, WriterFile> entry : ThreadConfig.get(Reporter.REPORTER_WRITER_BY_LEVEL).entrySet()) {
                CommonReporter.this.close(entry.getValue());
            }
        }
    }
}

