/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.common;

import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.google.common.collect.Sets;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDoubleLiteral;
import com.android.jack.ir.ast.JEnumLiteral;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFloatLiteral;
import com.android.jack.ir.ast.JIntegralConstant32;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JLongLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JStringLiteral;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.util.CloneExpressionVisitor;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class OptimizerUtils {
    public static boolean isConstructor(@Nonnull JMethod method) {
        return method instanceof JConstructor || JMethod.isClinit(method);
    }

    public static boolean isAssigned(@Nonnull JExpression expr) {
        JNode parent = expr.getParent();
        return parent instanceof JAsgOperation && ((JAsgOperation)parent).getLhs() == expr;
    }

    @Nonnull
    public static JExpression getAssignedValue(@Nonnull JExpression expr) {
        assert (OptimizerUtils.isAssigned(expr));
        return ((JAsgOperation)expr.getParent()).getRhs();
    }

    public static boolean areSameValueLiterals(@Nonnull JValueLiteral a, @Nonnull JValueLiteral b) {
        if (a == b) {
            return true;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        if (a instanceof JNullLiteral) {
            return true;
        }
        if (a instanceof JEnumLiteral) {
            JEnumLiteral aEnum = (JEnumLiteral)a;
            JEnumLiteral bEnum = (JEnumLiteral)b;
            return aEnum.getType().isSameType(bEnum.getType()) && aEnum.getFieldId().getName().equals(bEnum.getFieldId().getName());
        }
        if (a instanceof JBooleanLiteral) {
            return ((JBooleanLiteral)a).getValue() == ((JBooleanLiteral)b).getValue();
        }
        if (a instanceof JStringLiteral) {
            return ((JStringLiteral)a).getValue().equals(((JStringLiteral)b).getValue());
        }
        if (a instanceof JAbstractStringLiteral) {
            return false;
        }
        if (a instanceof JFloatLiteral) {
            return ((JFloatLiteral)a).getValue() == ((JFloatLiteral)b).getValue();
        }
        if (a instanceof JDoubleLiteral) {
            return ((JDoubleLiteral)a).getValue() == ((JDoubleLiteral)b).getValue();
        }
        if (a instanceof JLongLiteral) {
            return ((JLongLiteral)a).getValue() == ((JLongLiteral)b).getValue();
        }
        assert (a instanceof JIntegralConstant32);
        return ((JIntegralConstant32)((Object)a)).getIntValue() == ((JIntegralConstant32)((Object)b)).getIntValue();
    }

    @Nonnull
    public static <T extends JExpression> T cloneExpression(@Nonnull T expr) {
        return new CloneExpressionVisitor().cloneExpression(expr);
    }

    public static boolean isConstructorDelegation(@Nonnull JMethodCall call, @Nonnull JConstructor constructor) {
        if (!call.getMethodId().isInit() || !(call.getInstance() instanceof JThisRef)) {
            return false;
        }
        assert (call.getDispatchKind() == JMethodCall.DispatchKind.DIRECT);
        assert (constructor.getMethodIdWide().getKind() == MethodKind.INSTANCE_NON_VIRTUAL);
        return call.getReceiverType().isSameType(constructor.getEnclosingType());
    }

    @CheckForNull
    public static JValueLiteral asLiteralOrDefault(@Nonnull JExpression expression, @CheckForNull JValueLiteral defaultValue) {
        JLocal local;
        if (expression instanceof JValueLiteral) {
            return (JValueLiteral)expression;
        }
        Set<JLocal> localsSeen = Sets.newIdentityHashSet();
        while (expression instanceof JLocalRef && (local = ((JLocalRef)expression).getLocal()).isSynthetic() && !localsSeen.contains(local)) {
            List<DefinitionMarker> defs;
            localsSeen.add(local);
            UseDefsMarker usedRefs = expression.getMarker(UseDefsMarker.class);
            if (usedRefs == null || (defs = usedRefs.getDefs()).size() != 1) break;
            expression = defs.get(0).getValue();
        }
        return expression instanceof JValueLiteral ? (JValueLiteral)expression : defaultValue;
    }

    private OptimizerUtils() {
    }
}

