/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.common;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.optimizations.common.LiteralValueTrackerBase;
import com.android.jack.optimizations.common.OptimizerUtils;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class ConcurrentLiteralValueTracker
extends LiteralValueTrackerBase {
    @Nonnull
    private final AtomicReference<JValueLiteral> value = new AtomicReference();

    @CheckForNull
    public final JValueLiteral getConsolidatedValue() {
        assert (!this.isMultipleOrNonLiteralValue());
        return this.value.get();
    }

    @CheckForNull
    final JValueLiteral getRawValue() {
        return this.value.get();
    }

    public final void markExpression(@Nonnull JExpression expression) {
        if (this.isMultipleOrNonLiteralValue(this.value.get())) {
            return;
        }
        JValueLiteral candidate = this.asLiteral(expression);
        while (true) {
            JValueLiteral existing;
            if ((existing = this.value.get()) == null) {
                if (!this.value.compareAndSet(null, candidate)) continue;
                return;
            }
            if (this.isMultipleOrNonLiteralValue(existing) || OptimizerUtils.areSameValueLiterals(existing, candidate)) {
                return;
            }
            if (this.value.compareAndSet(existing, this.getMultipleOrNonLiteralValue())) break;
        }
    }

    public final boolean isMultipleOrNonLiteralValue() {
        return this.isMultipleOrNonLiteralValue(this.value.get());
    }
}

