/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.lookup;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.TypeFormatter;
import javax.annotation.Nonnull;

public abstract class CommonTypes {
    private static final String JAVA_LANG_ASSERTION_ERROR_SIGNATURE = "Ljava/lang/AssertionError;";
    private static final String JAVA_UTIL_CONCURRENT_ATOMIC_ATOMICREFERENCEFIELDUPDATER_SIGNATURE = "Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;";
    private static final String JAVA_UTIL_CONCURRENT_ATOMIC_ATOMICINTEGERFIELDUPDATER_SIGNATURE = "Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;";
    private static final String JAVA_UTIL_CONCURRENT_ATOMIC_ATOMICLONGFIELDUPDATER_SIGNATURE = "Ljava/util/concurrent/atomic/AtomicLongFieldUpdater;";
    private static final String JAVA_LANG_STRING_SIGNATURE = "Ljava/lang/String;";
    private static final String JAVA_LANG_STRING_BUILDER_SIGNATURE = "Ljava/lang/StringBuilder;";
    private static final String JAVA_LANG_NULL_POINTER_EXCEPTION_SIGNATURE = "Ljava/lang/NullPointerException;";
    private static final String JAVA_LANG_CLASS_SIGNATURE = "Ljava/lang/Class;";
    private static final String JAVA_LANG_ENUM_SIGNATURE = "Ljava/lang/Enum;";
    private static final String JAVA_LANG_OBJECT_SIGNATURE = "Ljava/lang/Object;";
    private static final String JAVA_IO_SERIALIZABLE_SIGNATURE = "Ljava/io/Serializable;";
    private static final String JAVA_LANG_CLONEABLE_SIGNATURE = "Ljava/lang/Cloneable;";
    private static final String JAVA_LANG_BOOLEAN_SIGNATURE = "Ljava/lang/Boolean;";
    private static final String JAVA_LANG_BYTE_SIGNATURE = "Ljava/lang/Byte;";
    private static final String JAVA_LANG_CHAR_SIGNATURE = "Ljava/lang/Character;";
    private static final String JAVA_LANG_SHORT_SIGNATURE = "Ljava/lang/Short;";
    private static final String JAVA_LANG_INTEGER_SIGNATURE = "Ljava/lang/Integer;";
    private static final String JAVA_LANG_FLOAT_SIGNATURE = "Ljava/lang/Float;";
    private static final String JAVA_LANG_DOUBLE_SIGNATURE = "Ljava/lang/Double;";
    private static final String JAVA_LANG_LONG_SIGNATURE = "Ljava/lang/Long;";
    private static final String JAVA_LANG_VOID_SIGNATURE = "Ljava/lang/Void;";
    @Nonnull
    private static final TypeFormatter formatter = Jack.getLookupFormatter();
    @Nonnull
    public static final CommonType JAVA_LANG_ASSERTION_ERROR = CommonType.ASSERTION_ERROR;
    @Nonnull
    public static final CommonType JAVA_UTIL_CONCURRENT_ATOMIC_ATOMICREFERENCEFIELDUPDATER = CommonType.ATOMICREFERENCEFIELDUPDATER;
    @Nonnull
    public static final CommonType JAVA_UTIL_CONCURRENT_ATOMIC_ATOMICINTEGERFIELDUPDATER = CommonType.ATOMIC_ATOMICINTEGERFIELDUPDATER;
    @Nonnull
    public static final CommonType JAVA_UTIL_CONCURRENT_ATOMIC_ATOMICLONGFIELDUPDATER = CommonType.ATOMIC_ATOMICLONGFIELDUPDATER;
    @Nonnull
    public static final CommonType JAVA_LANG_STRING = CommonType.STRING;
    @Nonnull
    public static final CommonType JAVA_LANG_STRING_BUILDER = CommonType.STRING_BUILDER;
    @Nonnull
    public static final CommonType JAVA_LANG_NULL_POINTER_EXCEPTION = CommonType.NULL_POINTER_EXCEPTION;
    @Nonnull
    public static final CommonType JAVA_LANG_CLASS = CommonType.CLASS;
    @Nonnull
    public static final CommonType JAVA_LANG_ENUM = CommonType.ENUM;
    @Nonnull
    public static final CommonType JAVA_LANG_OBJECT = CommonType.OBJECT;
    @Nonnull
    public static final CommonType JAVA_IO_SERIALIZABLE = CommonType.SERIALIZABLE;
    @Nonnull
    public static final CommonType JAVA_LANG_CLONEABLE = CommonType.CLONEABLE;
    @Nonnull
    public static final CommonType JAVA_LANG_BOOLEAN = CommonType.BOOLEAN;
    @Nonnull
    public static final CommonType JAVA_LANG_BYTE = CommonType.BYTE;
    @Nonnull
    public static final CommonType JAVA_LANG_CHAR = CommonType.CHAR;
    @Nonnull
    public static final CommonType JAVA_LANG_SHORT = CommonType.SHORT;
    @Nonnull
    public static final CommonType JAVA_LANG_INTEGER = CommonType.INTEGER;
    @Nonnull
    public static final CommonType JAVA_LANG_FLOAT = CommonType.FLOAT;
    @Nonnull
    public static final CommonType JAVA_LANG_DOUBLE = CommonType.DOUBLE;
    @Nonnull
    public static final CommonType JAVA_LANG_LONG = CommonType.LONG;
    @Nonnull
    public static final CommonType JAVA_LANG_VOID = CommonType.VOID;

    public static boolean isCommonType(@Nonnull CommonType commonType, @Nonnull JType type) {
        return commonType.getSignature().equals(formatter.getName(type));
    }

    public static enum CommonType {
        ASSERTION_ERROR("Ljava/lang/AssertionError;"),
        ATOMICREFERENCEFIELDUPDATER("Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;"),
        ATOMIC_ATOMICINTEGERFIELDUPDATER("Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;"),
        ATOMIC_ATOMICLONGFIELDUPDATER("Ljava/util/concurrent/atomic/AtomicLongFieldUpdater;"),
        STRING("Ljava/lang/String;"),
        STRING_BUILDER("Ljava/lang/StringBuilder;"),
        NULL_POINTER_EXCEPTION("Ljava/lang/NullPointerException;"),
        CLASS("Ljava/lang/Class;"),
        ENUM("Ljava/lang/Enum;"),
        OBJECT("Ljava/lang/Object;"),
        SERIALIZABLE("Ljava/io/Serializable;"),
        CLONEABLE("Ljava/lang/Cloneable;"),
        BOOLEAN("Ljava/lang/Boolean;"),
        BYTE("Ljava/lang/Byte;"),
        CHAR("Ljava/lang/Character;"),
        SHORT("Ljava/lang/Short;"),
        INTEGER("Ljava/lang/Integer;"),
        FLOAT("Ljava/lang/Float;"),
        DOUBLE("Ljava/lang/Double;"),
        LONG("Ljava/lang/Long;"),
        VOID("Ljava/lang/Void;");

        @Nonnull
        private final String signature;

        private CommonType(String signature) {
            this.signature = signature;
        }

        @Nonnull
        String getSignature() {
            return this.signature;
        }

        public String toString() {
            return this.signature;
        }
    }
}

