/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library.v0003;

import com.android.jack.google.common.collect.ImmutableSet;
import com.android.jack.library.FileType;
import com.android.jack.library.FileTypeDoesNotExistException;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.JackLibraryFactory;
import com.android.jack.library.LibraryFormatException;
import com.android.jack.library.LibraryIOException;
import com.android.jack.library.LibraryVersionException;
import com.android.jack.library.MissingLibraryPropertyException;
import com.android.jack.library.PrebuiltCompatibility;
import com.android.jack.library.v0003.OutputJackLibraryImpl;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileOrDirectoryException;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.DeflateFS;
import com.android.sched.vfs.GenericInputVFS;
import com.android.sched.vfs.InputVDir;
import com.android.sched.vfs.InputVFS;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.MessageDigestFS;
import com.android.sched.vfs.PrefixedFS;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VPath;
import com.android.sched.vfs.WrongVFSFormatException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class InputJackLibraryImpl
extends InputJackLibrary {
    @Nonnull
    private static final VPath RSC_PREFIX = new VPath("rsc", '/');
    @Nonnull
    private static final VPath LOG_PREFIX = new VPath("log", '/');
    @Nonnull
    private static final VPath META_PREFIX = new VPath("meta", '/');
    @Nonnull
    private static final VPath JAYCE_PREFIX = new VPath("jayce", '/');
    @Nonnull
    private static final VPath PREBUILT_PREFIX = new VPath("prebuilt", '/');
    @Nonnull
    private final Map<FileType, InputVFS> sectionVFS = new EnumMap<FileType, InputVFS>(FileType.class);
    @Nonnull
    private final VFS originalVFS;
    @CheckForNull
    private OutputJackLibraryImpl linkedOutputJackLib;
    private boolean closed = false;

    public InputJackLibraryImpl(@Nonnull VFS vfs, @Nonnull Properties libraryProperties) throws LibraryVersionException, LibraryFormatException {
        super(libraryProperties, vfs);
        this.originalVFS = vfs;
        this.check();
        this.fillFileTypes();
    }

    public InputJackLibraryImpl(@Nonnull OutputJackLibraryImpl jackOutputLibrary, @Nonnull Properties libraryProperties) throws LibraryFormatException, LibraryVersionException {
        super(libraryProperties, jackOutputLibrary.getVfs());
        this.linkedOutputJackLib = jackOutputLibrary;
        this.originalVFS = jackOutputLibrary.getVfs();
        jackOutputLibrary.incrementNumLinkedLibraries();
        this.check();
        this.fillFileTypes();
    }

    @Override
    @Nonnull
    public InputVFile getFile(@Nonnull FileType fileType, @Nonnull VPath typePath) throws FileTypeDoesNotExistException {
        try {
            if (!this.containsFileType(fileType)) {
                throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
            }
            InputVFS currentSectionVFS = this.getSectionVFS(fileType);
            return currentSectionVFS.getRootInputVDir().getInputVFile(this.buildFileVPath(fileType, typePath));
        }
        catch (NotFileOrDirectoryException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
        catch (NoSuchFileException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
    }

    @Override
    @Nonnull
    public InputVDir getDir(@Nonnull FileType fileType, @Nonnull VPath typePath) throws FileTypeDoesNotExistException {
        try {
            InputVFS currentSectionVFS = this.getSectionVFS(fileType);
            return currentSectionVFS.getRootInputVDir().getInputVDir(typePath);
        }
        catch (NotDirectoryException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
        catch (NoSuchFileException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
    }

    @Override
    @Nonnull
    public Iterator<InputVFile> iterator(@Nonnull FileType fileType) {
        if (!this.containsFileType(fileType)) {
            return ImmutableSet.of().iterator();
        }
        ArrayList<InputVFile> inputVFiles = new ArrayList<InputVFile>();
        this.fillFiles(this.getSectionVFS(fileType).getRootInputVDir(), inputVFiles);
        return inputVFiles.listIterator();
    }

    @Nonnull
    private synchronized InputVFS getSectionVFS(@Nonnull FileType fileType) {
        InputVFS currentSectionVFS;
        if (this.sectionVFS.containsKey((Object)fileType)) {
            currentSectionVFS = this.sectionVFS.get((Object)fileType);
        } else {
            BaseVFS inputVFS = null;
            try {
                inputVFS = new PrefixedFS(this.vfs, InputJackLibraryImpl.getSectionPath(fileType));
            }
            catch (CannotCreateFileException e) {
                throw new AssertionError((Object)e);
            }
            catch (NotDirectoryException e) {
                throw new AssertionError((Object)e);
            }
            if (fileType == FileType.PREBUILT || fileType == FileType.JAYCE && this.hasJayceDigest()) {
                try {
                    inputVFS = new MessageDigestFS(inputVFS, ThreadConfig.get(JackLibraryFactory.MESSAGE_DIGEST_ALGO));
                }
                catch (WrongVFSFormatException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (fileType != FileType.LOG) {
                inputVFS = new DeflateFS(inputVFS);
            }
            currentSectionVFS = new GenericInputVFS(inputVFS);
            this.sectionVFS.put(fileType, currentSectionVFS);
        }
        return currentSectionVFS;
    }

    @Override
    public synchronized void close() throws LibraryIOException {
        if (!this.closed) {
            if (this.linkedOutputJackLib != null) {
                this.linkedOutputJackLib.notifyToClose();
            } else if (!this.originalVFS.isClosed()) {
                try {
                    for (InputVFS currentSectionVFS : this.sectionVFS.values()) {
                        currentSectionVFS.close();
                    }
                    this.vfs.close();
                }
                catch (CannotCloseException e) {
                    throw new LibraryIOException(this.getLocation(), e);
                }
            }
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    @Nonnegative
    public int getMajorVersion() {
        return 3;
    }

    @Override
    @Nonnegative
    public int getSupportedMinorMin() {
        return 3;
    }

    @Override
    @Nonnegative
    public int getSupportedMinor() {
        return 3;
    }

    @Override
    @Nonnull
    public void delete(@Nonnull FileType fileType, @Nonnull VPath typePath) throws CannotDeleteFileException, FileTypeDoesNotExistException {
        try {
            InputVFS currentSectionVFS = this.getSectionVFS(fileType);
            currentSectionVFS.getRootInputVDir().getInputVFile(this.buildFileVPath(fileType, typePath)).delete();
        }
        catch (NotFileOrDirectoryException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
        catch (NoSuchFileException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.vfs.getPath();
    }

    @Nonnull
    public VPath buildFileVPath(@Nonnull FileType fileType, @Nonnull VPath vpath) {
        VPath clonedPath = vpath.clone();
        clonedPath.addSuffix(InputJackLibraryImpl.getExtension(fileType));
        return clonedPath;
    }

    @Override
    @CheckForNull
    public String getDigest() {
        if (this.containsFileType(FileType.PREBUILT)) {
            return this.getSectionVFS(FileType.PREBUILT).getDigest();
        }
        if (this.containsFileType(FileType.JAYCE)) {
            return this.getSectionVFS(FileType.JAYCE).getDigest();
        }
        return null;
    }

    @Override
    @Nonnull
    protected String getPropertyPrefix(@Nonnull FileType type) {
        return InputJackLibraryImpl.getPropertyPrefixImpl(type);
    }

    @Nonnull
    static String getPropertyPrefixImpl(@Nonnull FileType type) {
        switch (type) {
            case PREBUILT: {
                return "prebuilt";
            }
            case JAYCE: {
                return "jayce";
            }
            case META: {
                return "meta";
            }
            case LOG: {
                return "log";
            }
            case DEPENDENCIES: {
                return "meta";
            }
            case RSC: {
                return "rsc";
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    static String getExtension(@Nonnull FileType type) {
        switch (type) {
            case PREBUILT: {
                return ".dex";
            }
            case JAYCE: {
                return ".jayce";
            }
            case LOG: {
                return ".log";
            }
            case DEPENDENCIES: {
                return ".dep";
            }
        }
        return "";
    }

    @Nonnull
    static VPath getSectionPath(@Nonnull FileType type) {
        switch (type) {
            case PREBUILT: {
                return PREBUILT_PREFIX;
            }
            case JAYCE: {
                return JAYCE_PREFIX;
            }
            case META: {
                return META_PREFIX;
            }
            case LOG: {
                return LOG_PREFIX;
            }
            case DEPENDENCIES: {
                return META_PREFIX;
            }
            case RSC: {
                return RSC_PREFIX;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean hasCompliantPrebuilts() {
        Config config = ThreadConfig.getConfig();
        for (PropertyId<?> property : config.getPropertyIds()) {
            if (!property.hasCategory(PrebuiltCompatibility.class)) continue;
            try {
                String value = this.getProperty("config." + property.getName());
                PrebuiltCompatibility compatibility = property.getCategory(PrebuiltCompatibility.class);
                if (compatibility != null) {
                    if (compatibility.isCompatible(config, value)) continue;
                    logger.log(Level.FINE, "Property ''{0}'' with value ''{1}'' from library {2} is not compatible with current config ''{3}''", new Object[]{property.getName(), value, this.getLocation().getDescription(), String.valueOf(config.get(property))});
                    return false;
                }
                if (config.parseAs(value, property).equals(config.get(property))) continue;
                logger.log(Level.FINE, "Property ''{0}'' with value ''{1}'' from library {2} is not compatible with current config ''{3}''", new Object[]{property.getName(), value, this.getLocation().getDescription(), String.valueOf(config.get(property))});
                return false;
            }
            catch (MissingLibraryPropertyException e) {
                logger.log(Level.FINE, e.getMessage());
                return false;
            }
            catch (ParsingException e) {
                logger.log(Level.FINE, "Property ''{0}'' is malformed from library {1}: {2}", new Object[]{property.getName(), this.getLocation().getDescription(), e.getMessage()});
                return false;
            }
        }
        return true;
    }
}

