/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library.v0000;

import com.android.jack.google.common.collect.ImmutableSet;
import com.android.jack.library.FileType;
import com.android.jack.library.FileTypeDoesNotExistException;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.JackLibrary;
import com.android.jack.library.LibraryFormatException;
import com.android.jack.library.LibraryIOException;
import com.android.jack.library.LibraryVersionException;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileOrDirectoryException;
import com.android.sched.vfs.GenericInputVFS;
import com.android.sched.vfs.InputVDir;
import com.android.sched.vfs.InputVElement;
import com.android.sched.vfs.InputVFS;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class InputJackLibraryImpl
extends InputJackLibrary {
    @Nonnull
    private final List<InputVFile> resources = new ArrayList<InputVFile>();
    @Nonnull
    protected final InputVFS inputVFS;

    public InputJackLibraryImpl(@Nonnull VFS vfs, @Nonnull Properties libraryProperties) throws LibraryVersionException, LibraryFormatException {
        super(libraryProperties, vfs);
        this.inputVFS = new GenericInputVFS(vfs);
        this.check();
        this.fillFileTypes();
        this.fillResources(this.inputVFS.getRootInputVDir(), this.resources);
        if (!this.resources.isEmpty()) {
            this.fileTypes.add(FileType.RSC);
        }
    }

    @Override
    public void close() throws LibraryIOException {
        try {
            this.inputVFS.close();
        }
        catch (CannotCloseException e) {
            throw new LibraryIOException(this.getLocation(), e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.inputVFS.isClosed();
    }

    @Override
    @Nonnull
    public InputVFile getFile(@Nonnull FileType fileType, @Nonnull VPath typePath) throws FileTypeDoesNotExistException {
        if (!this.containsFileType(fileType)) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
        try {
            VPath clonedPath = typePath.clone();
            clonedPath.addSuffix(InputJackLibraryImpl.getExtension(fileType));
            return this.inputVFS.getRootInputVDir().getInputVFile(clonedPath);
        }
        catch (NotFileOrDirectoryException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
        catch (NoSuchFileException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
    }

    @Override
    @Nonnull
    public InputVDir getDir(@Nonnull FileType fileType, @Nonnull VPath typePath) throws FileTypeDoesNotExistException {
        try {
            return this.inputVFS.getRootInputVDir().getInputVDir(typePath);
        }
        catch (NotDirectoryException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
        catch (NoSuchFileException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
    }

    @Override
    @Nonnull
    public Iterator<InputVFile> iterator(@Nonnull FileType fileType) {
        if (!this.containsFileType(fileType)) {
            return ImmutableSet.of().iterator();
        }
        if (fileType == FileType.RSC) {
            return this.resources.iterator();
        }
        ArrayList<InputVFile> inputVFiles = new ArrayList<InputVFile>();
        InputJackLibraryImpl.fillFiles(this.inputVFS.getRootInputVDir(), InputJackLibraryImpl.getExtension(fileType), inputVFiles);
        return inputVFiles.iterator();
    }

    @Override
    @Nonnegative
    public int getMajorVersion() {
        return 0;
    }

    @Override
    @Nonnegative
    public int getSupportedMinorMin() {
        return 0;
    }

    @Override
    @Nonnegative
    public int getSupportedMinor() {
        return 0;
    }

    @Override
    @Nonnull
    public void delete(@Nonnull FileType fileType, @Nonnull VPath typePath) {
        throw new AssertionError();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.inputVFS.getPath();
    }

    @Override
    @CheckForNull
    public String getDigest() {
        return null;
    }

    private void fillResources(@Nonnull InputVDir vDir, @Nonnull List<InputVFile> files) {
        for (InputVElement inputVElement : vDir.list()) {
            if (inputVElement.isVDir()) {
                this.fillResources((InputVDir)inputVElement, files);
                continue;
            }
            InputVFile vFile = (InputVFile)inputVElement;
            if (InputJackLibraryImpl.isJayce(vFile) || InputJackLibraryImpl.isJPP(vFile) || vFile.getName().equals(JackLibrary.LIBRARY_PROPERTIES_VPATH.getLastName())) continue;
            files.add(vFile);
        }
    }

    private static boolean isJayce(@Nonnull InputVFile vFile) {
        return vFile.getName().endsWith(".jayce");
    }

    private static boolean isJPP(@Nonnull InputVFile vFile) {
        return vFile.getName().endsWith(".jpp");
    }

    @Nonnull
    private static String getExtension(@Nonnull FileType type) {
        switch (type) {
            case PREBUILT: {
                return ".dex";
            }
            case JAYCE: {
                return ".jayce";
            }
            case META: {
                return ".jpp";
            }
            case LOG: {
                return ".log";
            }
            case DEPENDENCIES: {
                return ".dep";
            }
        }
        return "";
    }

    private static void fillFiles(@Nonnull InputVDir vDir, @Nonnull String extension, @Nonnull List<InputVFile> files) {
        for (InputVElement inputVElement : vDir.list()) {
            if (inputVElement.isVDir()) {
                InputJackLibraryImpl.fillFiles((InputVDir)inputVElement, extension, files);
                continue;
            }
            InputVFile vFile = (InputVFile)inputVElement;
            if (!vFile.getName().endsWith(extension)) continue;
            files.add(vFile);
        }
    }

    @Override
    @Nonnull
    protected String getPropertyPrefix(@Nonnull FileType type) {
        switch (type) {
            case PREBUILT: {
                return "dex";
            }
            case JAYCE: {
                return "jayce";
            }
            case META: {
                return "jpp";
            }
            case LOG: {
                return "logs";
            }
            case DEPENDENCIES: {
                return "dependencies";
            }
            case RSC: {
                return "rsc";
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean hasCompliantPrebuilts() {
        return true;
    }

    @Override
    @Nonnull
    public void mergeInputLibraries(@Nonnull List<? extends InputLibrary> inputLibraries) {
        throw new UnsupportedOperationException();
    }
}

