/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.kohsuke.args4j.spi;

import com.android.jack.kohsuke.args4j.CmdLineException;
import com.android.jack.kohsuke.args4j.CmdLineParser;
import com.android.jack.kohsuke.args4j.OptionDef;
import com.android.jack.kohsuke.args4j.ParserProperties;
import com.android.jack.kohsuke.args4j.spi.Parameters;
import com.android.jack.kohsuke.args4j.spi.Setter;
import java.util.ResourceBundle;

public abstract class OptionHandler<T> {
    public final OptionDef option;
    public final Setter<? super T> setter;
    public final CmdLineParser owner;

    protected OptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter) {
        this.owner = parser;
        this.option = option;
        this.setter = setter;
    }

    public abstract int parseArguments(Parameters var1) throws CmdLineException;

    public abstract String getDefaultMetaVariable();

    public String getMetaVariable(ResourceBundle rb) {
        String localized;
        String token = this.option.metaVar();
        if (token.length() == 0) {
            token = this.getDefaultMetaVariable();
        }
        if (token == null) {
            return null;
        }
        if (rb != null && (localized = rb.getString(token)) != null) {
            token = localized;
        }
        return token;
    }

    public final String getNameAndMeta(ResourceBundle rb) {
        return this.getNameAndMeta(rb, ParserProperties.defaults());
    }

    public final String getNameAndMeta(ResourceBundle rb, ParserProperties properties) {
        String str = this.option.isArgument() ? "" : this.option.toString();
        String meta = this.getMetaVariable(rb);
        if (meta != null) {
            if (str.length() > 0) {
                str = str + properties.getOptionValueDelimiter();
            }
            str = str + meta;
        }
        return str;
    }
}

