/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMultiExpression;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NExpression;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class NMultiExpression
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.MULTI_EXPRESSION;
    @Nonnull
    public List<NExpression> exprs = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JMultiExpression jMultiExpression = (JMultiExpression)node;
        this.exprs = loader.load(NExpression.class, jMultiExpression.getExprs());
        this.sourceInfo = jMultiExpression.getSourceInfo();
    }

    @Override
    @Nonnull
    public JMultiExpression exportAsJast(@Nonnull ExportSession exportSession) throws JMethodLookupException, JTypeLookupException {
        assert (this.sourceInfo != null);
        ArrayList<JExpression> jExprs = new ArrayList<JExpression>(this.exprs.size());
        for (NExpression expr : this.exprs) {
            jExprs.add(expr.exportAsJast(exportSession));
        }
        JMultiExpression jMultiExpression = new JMultiExpression(this.sourceInfo, jExprs);
        return jMultiExpression;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNodes(this.exprs);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.exprs = in.readNodes(NExpression.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

