/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.jayce.DeclaredTypeNode;
import com.android.jack.jayce.FieldNode;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.MethodNode;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.v0004.NNode;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.nodes.HasSourceInfo;
import com.android.jack.jayce.v0004.nodes.NAnnotation;
import com.android.jack.jayce.v0004.nodes.NField;
import com.android.jack.jayce.v0004.nodes.NMethod;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class NDeclaredType
extends NNode
implements HasSourceInfo,
DeclaredTypeNode {
    @CheckForNull
    protected NodeLevel level;
    @Nonnull
    public List<NMethod> methods = Collections.emptyList();
    @Nonnull
    public List<NField> fields = Collections.emptyList();
    @Nonnull
    public List<NAnnotation> annotations = Collections.emptyList();

    @Override
    @Nonnull
    public abstract JDefinedClassOrInterface exportAsJast(@Nonnull ExportSession var1);

    @Override
    @Nonnull
    public NodeLevel getLevel() {
        assert (this.level != null);
        return this.level;
    }

    @Override
    public void loadAnnotations(@Nonnull JDefinedClassOrInterface loading, @Nonnull JayceClassOrInterfaceLoader loader) {
        if (!this.annotations.isEmpty()) {
            ExportSession exportSession = new ExportSession(loader.getSession(), NodeLevel.STRUCTURE);
            for (NAnnotation annotation : this.annotations) {
                JAnnotation annotationLiteral = annotation.exportAsJast(exportSession);
                loading.addAnnotation(annotationLiteral);
                annotationLiteral.updateParents(loading);
            }
        }
    }

    @Override
    @Nonnull
    public FieldNode getFieldNode(int fieldNodeIndex) {
        return this.fields.get(fieldNodeIndex);
    }

    @Override
    @Nonnull
    public MethodNode getMethodNode(@Nonnull int methodNodeIndex) {
        return this.methods.get(methodNodeIndex);
    }

    protected boolean areIndicesValid() {
        int i;
        boolean allValid = true;
        int size = this.methods.size();
        for (i = 0; i < size && allValid; allValid &= i == this.methods.get((int)i).methodNodeIndex, ++i) {
        }
        size = this.fields.size();
        for (i = 0; i < size && allValid; allValid &= i == this.fields.get((int)i).fieldNodeIndex, ++i) {
        }
        return allValid;
    }
}

