/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JContinueStatement;
import com.android.jack.ir.ast.JLabel;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NStatement;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NContinueStatement
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.CONTINUE_STATEMENT;
    @CheckForNull
    public String label;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JContinueStatement jContinueStatement = (JContinueStatement)node;
        this.label = ImportHelper.getLabelName(jContinueStatement.getLabel());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), jContinueStatement.getJCatchBlocks());
        this.sourceInfo = jContinueStatement.getSourceInfo();
    }

    @Override
    @Nonnull
    public JContinueStatement exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        JLabel jLabel = this.label == null ? null : new JLabel(this.sourceInfo, this.label);
        JContinueStatement jContinueStatement = new JContinueStatement(this.sourceInfo, jLabel);
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jContinueStatement));
        }
        return jContinueStatement;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeString(this.label);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.label = in.readString();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

