/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NExpression;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NArrayRef
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.ARRAY_REF;
    @CheckForNull
    public NExpression instance;
    @CheckForNull
    public NExpression index;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JArrayRef jArrayRef = (JArrayRef)node;
        this.instance = (NExpression)loader.load(jArrayRef.getInstance());
        this.index = (NExpression)loader.load(jArrayRef.getIndexExpr());
        this.sourceInfo = jArrayRef.getSourceInfo();
    }

    @Override
    @Nonnull
    public JArrayRef exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.instance != null);
        assert (this.index != null);
        JExpression jInstance = this.instance.exportAsJast(exportSession);
        JExpression jIndex = this.index.exportAsJast(exportSession);
        JArrayRef jArrayRef = new JArrayRef(this.sourceInfo, jInstance, jIndex);
        return jArrayRef;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNode(this.instance);
        out.writeNode(this.index);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.instance = in.readNode(NExpression.class);
        this.index = in.readNode(NExpression.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

