/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.util;

import com.android.jack.digest.OriginDigestElement;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class OriginDigestDescriptorHelper {
    @Nonnull
    private static OriginDigestElement[] values;
    @Nonnull
    private static int[] ids;
    private static int lastId;
    @Nonnull
    private static Set<OriginDigestElement> lastSet;

    @Nonnegative
    public static synchronized int getInt(@Nonnull Set<OriginDigestElement> set) {
        if (lastSet.equals(set)) {
            return lastId;
        }
        int id = 0;
        for (OriginDigestElement element : set) {
            id |= ids[element.ordinal()];
        }
        lastSet = set;
        lastId = id;
        return id;
    }

    @Nonnull
    public static synchronized Set<OriginDigestElement> getValue(@Nonnegative int id) {
        if (id == lastId) {
            return lastSet;
        }
        EnumSet<OriginDigestElement> set = EnumSet.noneOf(OriginDigestElement.class);
        for (int idx = 0; idx < values.length; ++idx) {
            if ((id & 1 << idx) == 0) continue;
            set.add(values[idx]);
        }
        lastSet = set;
        lastId = id;
        return set;
    }

    static {
        lastId = 0;
        lastSet = EnumSet.noneOf(OriginDigestElement.class);
        assert (OriginDigestElement.values().length == 9);
        values = new OriginDigestElement[9];
        OriginDigestDescriptorHelper.values[0] = OriginDigestElement.SOURCE;
        OriginDigestDescriptorHelper.values[1] = OriginDigestElement.BINARY;
        OriginDigestDescriptorHelper.values[2] = OriginDigestElement.LOCAL_NAME;
        OriginDigestDescriptorHelper.values[3] = OriginDigestElement.PRIVATE_NAME;
        OriginDigestDescriptorHelper.values[4] = OriginDigestElement.PACKAGE_NAME;
        OriginDigestDescriptorHelper.values[5] = OriginDigestElement.PROTECTED_NAME;
        OriginDigestDescriptorHelper.values[6] = OriginDigestElement.PUBLIC_NAME;
        OriginDigestDescriptorHelper.values[7] = OriginDigestElement.COMMENT;
        OriginDigestDescriptorHelper.values[8] = OriginDigestElement.FORMAT;
        ids = new int[9];
        OriginDigestDescriptorHelper.ids[OriginDigestElement.SOURCE.ordinal()] = 1;
        OriginDigestDescriptorHelper.ids[OriginDigestElement.BINARY.ordinal()] = 2;
        OriginDigestDescriptorHelper.ids[OriginDigestElement.LOCAL_NAME.ordinal()] = 4;
        OriginDigestDescriptorHelper.ids[OriginDigestElement.PRIVATE_NAME.ordinal()] = 8;
        OriginDigestDescriptorHelper.ids[OriginDigestElement.PACKAGE_NAME.ordinal()] = 16;
        OriginDigestDescriptorHelper.ids[OriginDigestElement.PROTECTED_NAME.ordinal()] = 32;
        OriginDigestDescriptorHelper.ids[OriginDigestElement.PUBLIC_NAME.ordinal()] = 64;
        OriginDigestDescriptorHelper.ids[OriginDigestElement.COMMENT.ordinal()] = 128;
        OriginDigestDescriptorHelper.ids[OriginDigestElement.FORMAT.ordinal()] = 256;
    }
}

