/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.digest.OriginDigestMarker;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NMarker;
import com.android.jack.jayce.v0003.util.OriginDigestDescriptorHelper;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NOriginDigest
extends NMarker {
    @Nonnull
    public static final Token TOKEN = Token.ORIGIN_DIGEST;
    private int descriptor;
    @CheckForNull
    private String algo;
    @CheckForNull
    private byte[] digest;
    @CheckForNull
    private String emitter;
    private int major;
    private int minor;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        OriginDigestMarker marker = (OriginDigestMarker)node;
        this.algo = marker.getAlgo();
        this.digest = marker.getDigest();
        this.descriptor = OriginDigestDescriptorHelper.getInt(marker.getDescriptor());
        this.emitter = marker.getEmitterId();
        this.major = marker.getMajorCode();
        this.minor = marker.getMinorCode();
    }

    @Override
    @Nonnull
    public OriginDigestMarker exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.algo != null);
        assert (this.digest != null);
        assert (this.emitter != null);
        return new OriginDigestMarker(OriginDigestDescriptorHelper.getValue(this.descriptor), this.algo, this.digest, this.emitter, this.major, this.minor);
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        assert (this.digest != null);
        out.writeInt(this.descriptor);
        out.writeString(this.algo);
        out.writeBuffer(this.digest);
        out.writeString(this.emitter);
        out.writeInt(this.major);
        out.writeInt(this.minor);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.descriptor = in.readInt();
        this.algo = in.readString();
        this.digest = in.readBuffer();
        this.emitter = in.readString();
        this.major = in.readInt();
        this.minor = in.readInt();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

