/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JParameterUnresolved;
import com.android.jack.jayce.linker.ParameterRefLinker;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NExpression;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NParameterRef
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.PARAMETER_REF;
    @CheckForNull
    public String localId;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JParameterRef jRef = (JParameterRef)node;
        this.localId = loader.getParameterSymbols().getId(jRef.getParameter());
        this.sourceInfo = loader.load(jRef.getSourceInfo());
    }

    @Override
    @Nonnull
    public JParameterRef exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        assert (this.localId != null);
        JParameterRef jRef = JParameterUnresolved.INSTANCE.makeRef(this.sourceInfo.exportAsJast(exportSession));
        exportSession.getParameterResolver().addLink(this.localId, new ParameterRefLinker(jRef));
        return jRef;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeId(this.localId);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.localId = in.readId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

