/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NExpression;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NNewArray
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.NEW_ARRAY;
    @CheckForNull
    public String type;
    @Nonnull
    public List<NExpression> dims = Collections.emptyList();
    @Nonnull
    public List<NExpression> initializers = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JNewArray jNewArray = (JNewArray)node;
        this.type = ImportHelper.getSignatureName(jNewArray.getArrayType());
        this.dims = loader.load(NExpression.class, jNewArray.getDims());
        this.initializers = loader.load(NExpression.class, jNewArray.getInitializers());
        this.sourceInfo = loader.load(jNewArray.getSourceInfo());
    }

    @Override
    @Nonnull
    public JNewArray exportAsJast(@Nonnull ExportSession exportSession) throws JMethodLookupException, JTypeLookupException {
        assert (this.sourceInfo != null);
        assert (this.type != null);
        JArrayType jType = (JArrayType)exportSession.getLookup().getType(this.type);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        if (this.initializers.isEmpty()) {
            ArrayList<JExpression> jDims = new ArrayList<JExpression>(this.dims.size());
            for (NExpression expr : this.dims) {
                jDims.add(expr.exportAsJast(exportSession));
            }
            return JNewArray.createWithDims(jSourceInfo, jType, jDims);
        }
        ArrayList<JExpression> jInitializers = new ArrayList<JExpression>(this.initializers.size());
        for (NExpression expr : this.initializers) {
            jInitializers.add(expr.exportAsJast(exportSession));
        }
        return JNewArray.createWithInits(jSourceInfo, jType, jInitializers);
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeId(this.type);
        out.writeNodes(this.dims);
        out.writeNodes(this.initializers);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.type = in.readId();
        this.dims = in.readNodes(NExpression.class);
        this.initializers = in.readNodes(NExpression.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

