/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import javax.annotation.Nonnull;

public class JModifier {
    public static final int DEFAULT = 0;
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SUPER = 32;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int BRIDGE = 64;
    public static final int TRANSIENT = 128;
    public static final int VARARGS = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICTFP = 2048;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    public static final int STATIC_INIT = 65536;
    public static final int DEPRECATED = 0x100000;
    public static final int COMPILE_TIME_CONSTANT = 131072;
    @Deprecated
    public static final int ANONYMOUS_TYPE = 262144;
    public static final int CAPTURED_VARIABLE = 524288;
    public static final int LAMBDA_METHOD = 0x200000;
    private static final int TYPE_MODIFIER_MASK = 1080895;
    private static final int FIELD_MODIFIER_MASK = 1200351;
    private static final int METHOD_MODIFIER_MASK = 3218943;
    private static final int LOCAL_MODIFIER_MASK = 528400;

    public static boolean isPublic(int modifier) {
        return (modifier & 1) == 1;
    }

    public static boolean isPrivate(int modifier) {
        return (modifier & 2) == 2;
    }

    public static boolean isProtected(int modifier) {
        return (modifier & 4) == 4;
    }

    public static boolean isStatic(int modifier) {
        return (modifier & 8) == 8;
    }

    public static boolean isFinal(int modifier) {
        return (modifier & 0x10) == 16;
    }

    public static boolean isSynchronized(int modifier) {
        return (modifier & 0x20) == 32;
    }

    public static boolean isVolatile(int modifier) {
        return (modifier & 0x40) == 64;
    }

    public static boolean isBridge(int modifier) {
        return (modifier & 0x40) == 64;
    }

    public static boolean isTransient(int modifier) {
        return (modifier & 0x80) == 128;
    }

    public static boolean isVarargs(int modifier) {
        return (modifier & 0x80) == 128;
    }

    public static boolean isNative(int modifier) {
        return (modifier & 0x100) == 256;
    }

    public static boolean isInterface(int modifier) {
        return (modifier & 0x200) == 512;
    }

    public static boolean isAbstract(int modifier) {
        return (modifier & 0x400) == 1024;
    }

    public static boolean isStrictfp(int modifier) {
        return (modifier & 0x800) == 2048;
    }

    public static boolean isSynthetic(int modifier) {
        return (modifier & 0x1000) == 4096;
    }

    public static boolean isCapturedVariable(int modifier) {
        return (modifier & 0x80000) == 524288;
    }

    public static boolean isLambdaMethod(int modifier) {
        return (modifier & 0x200000) == 0x200000;
    }

    public static boolean isAnnotation(int modifier) {
        return (modifier & 0x2000) == 8192;
    }

    public static boolean isEnum(int modifier) {
        return (modifier & 0x4000) == 16384;
    }

    public static boolean isCompileTimeConstant(int modifier) {
        return (modifier & 0x20000) == 131072;
    }

    public static boolean isStaticInitializer(int modifier) {
        return (modifier & 0x10000) == 65536;
    }

    public static boolean isDeprecated(int modifier) {
        return (modifier & 0x100000) == 0x100000;
    }

    public static boolean isTypeModifier(int modifier) {
        return (modifier & 0x107E3F) == modifier;
    }

    public static boolean isValidTypeModifier(int modifier) {
        if (!JModifier.checkAccessibilityFlags(modifier)) {
            return false;
        }
        if (JModifier.isAnnotation(modifier) && JModifier.isInterface(modifier) && JModifier.isAbstract(modifier) && !JModifier.isFinal(modifier) && !JModifier.isEnum(modifier)) {
            return true;
        }
        if (JModifier.isInterface(modifier) && JModifier.isAbstract(modifier) && !JModifier.isFinal(modifier) && !JModifier.isEnum(modifier)) {
            return true;
        }
        if (JModifier.isEnum(modifier) && !JModifier.isAbstract(modifier)) {
            return true;
        }
        return !JModifier.isAbstract(modifier) || !JModifier.isFinal(modifier);
    }

    public static boolean isFieldModifier(int modifier) {
        return (modifier & 0x1250DF) == modifier;
    }

    public static boolean isValidFieldModifier(int modifier) {
        if (!JModifier.checkAccessibilityFlags(modifier)) {
            return false;
        }
        return !JModifier.isFinal(modifier) || !JModifier.isVolatile(modifier);
    }

    public static boolean checkAccessibilityFlags(int modifier) {
        if (JModifier.isPublic(modifier) && (JModifier.isProtected(modifier) || JModifier.isPrivate(modifier))) {
            return false;
        }
        return !JModifier.isProtected(modifier) || !JModifier.isPublic(modifier) && !JModifier.isPrivate(modifier);
    }

    public static boolean isMethodModifier(int modifier) {
        return (modifier & 0x311DFF) == modifier;
    }

    public static boolean isValidMethodModifier(int modifier) {
        if (!JModifier.checkAccessibilityFlags(modifier)) {
            return false;
        }
        if (JModifier.isAbstract(modifier) && (JModifier.isFinal(modifier) || JModifier.isNative(modifier) || JModifier.isPrivate(modifier) || JModifier.isStatic(modifier) || JModifier.isStrictfp(modifier) || JModifier.isSynchronized(modifier))) {
            return false;
        }
        if (JModifier.isBridge(modifier) && JModifier.isSynchronized(modifier)) {
            return false;
        }
        return !JModifier.isStaticInitializer(modifier) || JModifier.isStatic(modifier);
    }

    public static boolean isLocalModifier(int modifier) {
        return (modifier & 0x81010) == modifier;
    }

    public static boolean isParameterModifier(int modifier) {
        return (modifier & 0x81010) == modifier;
    }

    private static void getStringModifierCommon(int modifier, StringBuilder modifierStrBuilder) {
        if (JModifier.isPublic(modifier)) {
            modifierStrBuilder.append("public ");
        }
        if (JModifier.isPrivate(modifier)) {
            modifierStrBuilder.append("private ");
        }
        if (JModifier.isProtected(modifier)) {
            modifierStrBuilder.append("protected ");
        }
        if (JModifier.isStatic(modifier)) {
            modifierStrBuilder.append("static ");
        }
        if (JModifier.isFinal(modifier)) {
            modifierStrBuilder.append("final ");
        }
        if (JModifier.isSynthetic(modifier)) {
            modifierStrBuilder.append("synthetic ");
        }
    }

    public static String getStringTypeModifier(int modifier) {
        assert (JModifier.isTypeModifier(modifier));
        assert (JModifier.isValidTypeModifier(modifier));
        StringBuilder modifierStrBuilder = new StringBuilder();
        JModifier.getStringModifierCommon(modifier, modifierStrBuilder);
        if (JModifier.isAbstract(modifier)) {
            modifierStrBuilder.append("abstract ");
        }
        if (JModifier.isEnum(modifier)) {
            modifierStrBuilder.append("enum ");
        }
        if (JModifier.isStrictfp(modifier)) {
            modifierStrBuilder.append("strictfp ");
        }
        return modifierStrBuilder.toString();
    }

    public static String getStringFieldModifier(int modifier) {
        assert (JModifier.isFieldModifier(modifier));
        assert (JModifier.isValidFieldModifier(modifier));
        StringBuilder modifierStrBuilder = new StringBuilder();
        JModifier.getStringModifierCommon(modifier, modifierStrBuilder);
        if (JModifier.isVolatile(modifier)) {
            modifierStrBuilder.append("volatile ");
        }
        if (JModifier.isTransient(modifier)) {
            modifierStrBuilder.append("transient ");
        }
        if (JModifier.isEnum(modifier)) {
            modifierStrBuilder.append("enum ");
        }
        return modifierStrBuilder.toString();
    }

    public static String getStringMethodModifier(int modifier) {
        assert (JModifier.isMethodModifier(modifier));
        assert (JModifier.isValidMethodModifier(modifier));
        StringBuilder modifierStrBuilder = new StringBuilder();
        JModifier.getStringModifierCommon(modifier, modifierStrBuilder);
        if (JModifier.isAbstract(modifier)) {
            modifierStrBuilder.append("abstract ");
        }
        if (JModifier.isNative(modifier)) {
            modifierStrBuilder.append("native ");
        }
        if (JModifier.isSynchronized(modifier)) {
            modifierStrBuilder.append("synchronized ");
        }
        return modifierStrBuilder.toString();
    }

    @Nonnull
    public static String getStringVariableModifier(int modifier) {
        assert (JModifier.isLocalModifier(modifier));
        StringBuilder modifierStrBuilder = new StringBuilder();
        JModifier.getStringModifierCommon(modifier, modifierStrBuilder);
        if (JModifier.isCapturedVariable(modifier)) {
            modifierStrBuilder.append("captured ");
        }
        return modifierStrBuilder.toString();
    }
}

