/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JEnum;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import javax.annotation.Nonnull;

public class IncompatibleJTypeLookupException
extends JTypeLookupException {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final JType found;
    @Nonnull
    private final Class<? extends JClassOrInterface> expectedClass;

    public IncompatibleJTypeLookupException(@Nonnull JType found, @Nonnull Class<? extends JClassOrInterface> expectedClass) {
        this.found = found;
        this.expectedClass = expectedClass;
    }

    public IncompatibleJTypeLookupException(@Nonnull JDefinedClassOrInterface found, @Nonnull Class<? extends JClassOrInterface> expectedClass, @Nonnull Exception cause) {
        super(cause);
        this.found = found;
        this.expectedClass = expectedClass;
    }

    @Override
    @Nonnull
    public String getMessage() {
        return Jack.getUserFriendlyFormatter().getName(this.found) + " found as " + IncompatibleJTypeLookupException.getTypeKind(this.found.getClass()) + " instead of " + IncompatibleJTypeLookupException.getTypeKind(this.expectedClass);
    }

    @Nonnull
    private static String getTypeKind(@Nonnull Class<? extends JType> typeClass) {
        if (JEnum.class.isAssignableFrom(typeClass)) {
            return "enum";
        }
        if (JAnnotationType.class.isAssignableFrom(typeClass)) {
            return "annotation";
        }
        if (JClass.class.isAssignableFrom(typeClass)) {
            return "class";
        }
        if (JInterface.class.isAssignableFrom(typeClass)) {
            return "interface";
        }
        return "<undefined>";
    }
}

