/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.core;

import com.android.jack.freemarker.core.BreakInstruction;
import com.android.jack.freemarker.core.Case;
import com.android.jack.freemarker.core.Environment;
import com.android.jack.freemarker.core.EvalUtil;
import com.android.jack.freemarker.core.Expression;
import com.android.jack.freemarker.core.ParameterRole;
import com.android.jack.freemarker.core.TemplateElement;
import com.android.jack.freemarker.template.TemplateException;
import java.io.IOException;

final class SwitchBlock
extends TemplateElement {
    private Case defaultCase;
    private final Expression searched;

    SwitchBlock(Expression searched) {
        this.searched = searched;
        this.setChildBufferCapacity(4);
    }

    void addCase(Case cas) {
        if (cas.condition == null) {
            this.defaultCase = cas;
        }
        this.addChild(cas);
    }

    TemplateElement[] accept(Environment env) throws TemplateException, IOException {
        boolean processedCase = false;
        int ln = this.getChildCount();
        try {
            for (int i = 0; i < ln; ++i) {
                Case cas = (Case)this.getChild(i);
                boolean processCase = false;
                if (processedCase) {
                    processCase = true;
                } else if (cas.condition != null) {
                    processCase = EvalUtil.compare(this.searched, 1, "case==", cas.condition, cas.condition, env);
                }
                if (!processCase) continue;
                env.visit(cas);
                processedCase = true;
            }
            if (!processedCase && this.defaultCase != null) {
                env.visit(this.defaultCase);
            }
        }
        catch (BreakInstruction.Break break_) {
            // empty catch block
        }
        return null;
    }

    protected String dump(boolean canonical) {
        StringBuilder buf = new StringBuilder();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        buf.append(' ');
        buf.append(this.searched.getCanonicalForm());
        if (canonical) {
            buf.append('>');
            int ln = this.getChildCount();
            for (int i = 0; i < ln; ++i) {
                Case cas = (Case)this.getChild(i);
                buf.append(cas.getCanonicalForm());
            }
            buf.append("</").append(this.getNodeTypeSymbol()).append('>');
        }
        return buf.toString();
    }

    String getNodeTypeSymbol() {
        return "#switch";
    }

    int getParameterCount() {
        return 1;
    }

    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.searched;
    }

    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.VALUE;
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

